/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.animation.Animation;
import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Viewport;
import com.spinyowl.legui.component.event.scrollbar.ScrollBarChangeValueEvent;
import com.spinyowl.legui.component.misc.animation.scrollbar.ScrollBarAnimation;
import com.spinyowl.legui.component.misc.listener.scrollbar.ScrollBarMouseClickEventListener;
import com.spinyowl.legui.component.misc.listener.scrollbar.ScrollBarMouseDragEventListener;
import com.spinyowl.legui.component.misc.listener.scrollbar.ScrollBarScrollListener;
import com.spinyowl.legui.component.optional.Orientation;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.event.MouseDragEvent;
import com.spinyowl.legui.event.ScrollEvent;
import com.spinyowl.legui.listener.EventListener;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.theme.Themes;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;
import org.joml.Vector4f;

public class ScrollBar
extends Component {
    public static final float MIN_SCROLL_SIZE = 1.0f;
    private Orientation orientation = Orientation.VERTICAL;
    private float minValue = 0.0f;
    private float maxValue = 100.0f;
    private float curValue = 0.0f;
    private float scrollStep = 0.1f;
    private float visibleAmount;
    private boolean arrowsEnabled = true;
    private float arrowSize = 16.0f;
    private Vector4f arrowColor = ColorConstants.darkGray();
    private Vector4f scrollColor = ColorConstants.darkGray();
    private boolean scrolling = false;
    private Viewport viewport;
    private Animation animation;

    public ScrollBar() {
        this.initialize();
    }

    public ScrollBar(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize();
    }

    public ScrollBar(Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize();
    }

    public ScrollBar(float curValue) {
        this();
        this.setCurValue(curValue);
    }

    public ScrollBar(float x, float y, float width, float height, float curValue) {
        this(x, y, width, height);
        this.setCurValue(curValue);
    }

    public ScrollBar(Vector2f position, Vector2f size, float curValue) {
        this(position, size);
        this.setCurValue(curValue);
    }

    private void initialize() {
        this.getListenerMap().addListener(ScrollEvent.class, new ScrollBarScrollListener());
        this.getListenerMap().addListener(MouseDragEvent.class, new ScrollBarMouseDragEventListener());
        this.getListenerMap().addListener(MouseClickEvent.class, new ScrollBarMouseClickEventListener());
        this.animation = new ScrollBarAnimation(this);
        this.animation.startAnimation();
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(ScrollBar.class).applyAll(this);
    }

    public boolean isScrolling() {
        return this.scrolling;
    }

    public void setScrolling(boolean scrolling) {
        this.scrolling = scrolling;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void setViewport(Viewport viewport) {
        this.viewport = viewport;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation != null) {
            this.orientation = orientation;
        }
    }

    public float getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowSize(float arrowSize) {
        this.arrowSize = arrowSize;
    }

    public boolean isArrowsEnabled() {
        return this.arrowsEnabled;
    }

    public void setArrowsEnabled(boolean arrowsEnabled) {
        this.arrowsEnabled = arrowsEnabled;
    }

    public Vector4f getScrollColor() {
        return this.scrollColor;
    }

    public void setScrollColor(Vector4f scrollColor) {
        this.scrollColor = scrollColor;
    }

    public Vector4f getArrowColor() {
        return this.arrowColor;
    }

    public void setArrowColor(Vector4f arrowColor) {
        this.arrowColor = arrowColor;
    }

    public float getVisibleAmount() {
        return this.visibleAmount;
    }

    public void setVisibleAmount(float visibleAmount) {
        if (visibleAmount > this.minValue && visibleAmount <= this.maxValue) {
            this.visibleAmount = visibleAmount;
        }
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public float getCurValue() {
        return this.curValue;
    }

    public void setCurValue(float curValue) {
        this.curValue = curValue < this.minValue ? this.minValue : (curValue > this.maxValue ? this.maxValue : curValue);
    }

    public float getScrollStep() {
        return this.scrollStep;
    }

    public void setScrollStep(float scrollStep) {
        if (scrollStep > 0.0f) {
            this.scrollStep = scrollStep;
        }
    }

    public void addScrollBarChangeValueEventListener(EventListener<ScrollBarChangeValueEvent> eventListener) {
        this.getListenerMap().addListener(ScrollBarChangeValueEvent.class, eventListener);
    }

    public List<EventListener<ScrollBarChangeValueEvent>> getScrollBarChangeValueEvents() {
        return this.getListenerMap().getListeners(ScrollBarChangeValueEvent.class);
    }

    public void removeScrollBarChangeValueEventListener(EventListener<ScrollBarChangeValueEvent> eventListener) {
        this.getListenerMap().removeListener(ScrollBarChangeValueEvent.class, eventListener);
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        if (this.animation != null) {
            this.animation.stopAnimation();
        }
        this.animation = animation;
        if (animation != null) {
            this.animation.startAnimation();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScrollBar scrollBar = (ScrollBar)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.minValue, scrollBar.minValue).append(this.maxValue, scrollBar.maxValue).append(this.curValue, scrollBar.curValue).append(this.scrollStep, scrollBar.scrollStep).append(this.visibleAmount, scrollBar.visibleAmount).append(this.arrowsEnabled, scrollBar.arrowsEnabled).append(this.arrowSize, scrollBar.arrowSize).append((Object)this.orientation, (Object)scrollBar.orientation).append((Object)this.arrowColor, (Object)scrollBar.arrowColor).append((Object)this.scrollColor, (Object)scrollBar.scrollColor).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.orientation).append(this.minValue).append(this.maxValue).append(this.curValue).append(this.scrollStep).append(this.visibleAmount).append(this.arrowsEnabled).append(this.arrowSize).append((Object)this.arrowColor).append((Object)this.scrollColor).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("orientation", (Object)this.orientation).append("minValue", this.minValue).append("maxValue", this.maxValue).append("curValue", this.curValue).append("visibleAmount", this.visibleAmount).append("arrowsEnabled", this.arrowsEnabled).append("arrowSize", this.arrowSize).append("arrowColor", (Object)this.arrowColor).append("scrollColor", (Object)this.scrollColor).toString();
    }
}

