/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.AbstractTextComponent;
import com.spinyowl.legui.component.RadioButtonGroup;
import com.spinyowl.legui.component.misc.listener.radiobutton.RadioButtonClickEventListener;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.icon.CharIcon;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.theme.Themes;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;

public class RadioButton
extends AbstractTextComponent {
    public static final String DEFAULT_RADIO_BUTTON_TEXT = "RadioButton";
    private Icon iconUnchecked = new CharIcon(new Vector2f(14.0f, 14.0f), "MaterialIcons-Regular", '\ue836');
    private Icon iconChecked = new CharIcon(new Vector2f(14.0f, 14.0f), "MaterialIcons-Regular", '\ue837');
    private boolean checked;
    private RadioButtonGroup radioButtonGroup;

    public RadioButton() {
        this(DEFAULT_RADIO_BUTTON_TEXT);
    }

    public RadioButton(float x, float y, float width, float height) {
        this(DEFAULT_RADIO_BUTTON_TEXT, x, y, width, height);
    }

    public RadioButton(Vector2f position, Vector2f size) {
        this(DEFAULT_RADIO_BUTTON_TEXT, position, size);
    }

    public RadioButton(String text) {
        this.initialize(text);
    }

    public RadioButton(String text, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize(text);
    }

    public RadioButton(String text, Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize(text);
    }

    private void initialize(String text) {
        this.textState = new TextState(text);
        this.getStyle().setBorder(null);
        this.getListenerMap().addListener(MouseClickEvent.class, new RadioButtonClickEventListener());
        this.iconUnchecked.setHorizontalAlign(HorizontalAlign.LEFT);
        this.iconChecked.setHorizontalAlign(HorizontalAlign.LEFT);
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(RadioButton.class).applyAll(this);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        if (this.radioButtonGroup != null) {
            this.radioButtonGroup.setSelection(this, checked);
        }
    }

    public RadioButtonGroup getRadioButtonGroup() {
        return this.radioButtonGroup;
    }

    public void setRadioButtonGroup(RadioButtonGroup radioButtonGroup) {
        if (this.radioButtonGroup != null) {
            this.radioButtonGroup.remove(this);
        }
        this.radioButtonGroup = radioButtonGroup;
        this.radioButtonGroup.add(this);
        if (this.checked) {
            if (radioButtonGroup.getSelection() != null) {
                this.checked = false;
            } else {
                radioButtonGroup.setSelection(this, true);
            }
        }
    }

    public Icon getIconUnchecked() {
        return this.iconUnchecked;
    }

    public void setIconUnchecked(Icon iconUnchecked) {
        this.iconUnchecked = iconUnchecked;
    }

    public Icon getIconChecked() {
        return this.iconChecked;
    }

    public void setIconChecked(Icon iconChecked) {
        this.iconChecked = iconChecked;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RadioButton that = (RadioButton)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.checked, that.checked).append((Object)this.textState, (Object)that.textState).append((Object)this.radioButtonGroup, (Object)that.radioButtonGroup).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.textState).append(this.checked).append((Object)this.radioButtonGroup).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("textState", (Object)this.textState).append("checked", this.checked).append("radioButtonGroup", (Object)this.radioButtonGroup).toString();
    }
}

