/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.theme.Themes;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;
import org.joml.Vector4f;

public class ProgressBar
extends Component {
    public static final float MAX_VALUE = 100.0f;
    public static final float MIN_VALUE = 0.0f;
    private float value;
    private Vector4f progressColor = ColorConstants.green();

    public ProgressBar() {
        this.initialize();
    }

    public ProgressBar(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize();
    }

    public ProgressBar(Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize();
    }

    private void initialize() {
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(ProgressBar.class).applyAll(this);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value < 0.0f ? 0.0f : (value > 100.0f ? 100.0f : value);
    }

    public Vector4f getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(Vector4f progressColor) {
        this.progressColor = progressColor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgressBar that = (ProgressBar)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.value, that.value).append((Object)this.progressColor, (Object)that.progressColor).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.value).append((Object)this.progressColor).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("value", this.value).append("progressColor", (Object)this.progressColor).toString();
    }
}

