/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Layer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;

public class Frame {
    private final List<Layer> layers = new CopyOnWriteArrayList<Layer>();
    private Layer tooltipLayer;
    private Layer componentLayer;

    public Frame(float width, float height) {
        this.initialize(width, height);
    }

    public Frame() {
        this.initialize(10.0f, 10.0f);
    }

    public Frame(Vector2f size) {
        this.initialize(size.x, size.y);
    }

    private void initialize(float width, float height) {
        this.tooltipLayer = new Layer();
        this.tooltipLayer.setEventPassable(true);
        this.tooltipLayer.setEventReceivable(false);
        this.componentLayer = new Layer();
        this.componentLayer.setFocusable(true);
        this.tooltipLayer.setFrame(this);
        this.componentLayer.setFrame(this);
        this.setSize(width, height);
    }

    public void setSize(Vector2f size) {
        this.setSize(size.x, size.y);
    }

    public void setSize(float width, float height) {
        this.tooltipLayer.setSize(width, height);
        this.componentLayer.setSize(width, height);
        this.layers.forEach(l -> l.setSize(width, height));
    }

    public void addLayer(Layer layer) {
        if (layer == null || layer == this.tooltipLayer || layer == this.componentLayer) {
            return;
        }
        if (!this.containsLayer(layer) && this.layers.add(layer)) {
            this.changeFrame(layer);
        }
    }

    private void changeFrame(Layer layer) {
        Frame frame = layer.getFrame();
        if (frame == this) {
            return;
        }
        if (frame != null) {
            frame.removeLayer(layer);
        }
        layer.setFrame(this);
    }

    public void removeLayer(Layer layer) {
        boolean removed;
        if (layer == null || layer == this.tooltipLayer || layer == this.componentLayer) {
            return;
        }
        Frame frame = layer.getFrame();
        if (frame == this && this.containsLayer(layer) && (removed = this.layers.remove(layer))) {
            layer.setParent(null);
        }
    }

    public boolean containsLayer(Layer layer) {
        return layer != null && (layer == this.tooltipLayer || layer == this.componentLayer || this.layers.stream().anyMatch(l -> l == layer));
    }

    public Layer getComponentLayer() {
        return this.componentLayer;
    }

    public void setComponentLayer(Layer componentLayer) {
        this.componentLayer = Objects.requireNonNull(componentLayer);
    }

    public Layer getTooltipLayer() {
        return this.tooltipLayer;
    }

    public void setTooltipLayer(Layer tooltipLayer) {
        this.tooltipLayer = Objects.requireNonNull(tooltipLayer);
    }

    public List<Layer> getLayers() {
        return new ArrayList<Layer>(this.layers);
    }

    public List<Layer> getAllLayers() {
        ArrayList<Layer> layerList = new ArrayList<Layer>();
        layerList.add(this.componentLayer);
        layerList.addAll(this.layers);
        layerList.add(this.tooltipLayer);
        return layerList;
    }

    public Component getContainer() {
        return this.componentLayer;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.tooltipLayer).append((Object)this.componentLayer).append(this.layers).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Frame frame = (Frame)obj;
        return new EqualsBuilder().append((Object)this.tooltipLayer, (Object)frame.tooltipLayer).append((Object)this.componentLayer, (Object)frame.componentLayer).append(this.layers, frame.layers).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("tooltipLayer", (Object)this.tooltipLayer).append("componentLayer", (Object)this.componentLayer).append("layers", this.layers).toString();
    }
}

