/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.component.Layer;
import com.spinyowl.legui.component.Widget;
import com.spinyowl.legui.component.event.widget.WidgetCloseEvent;
import com.spinyowl.legui.component.misc.listener.dialog.DialogCloseEventListener;
import com.spinyowl.legui.theme.Themes;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class Dialog
extends Widget {
    public static final String DEFAULT_DIALOG_TITLE = "Dialog";
    private Frame frame;
    private DialogLayer dialogLayer = new DialogLayer();

    public Dialog() {
        this.initialize(null, DEFAULT_DIALOG_TITLE);
    }

    public Dialog(float width, float height) {
        this.initialize(new Vector2f(width, height), DEFAULT_DIALOG_TITLE);
    }

    public Dialog(Vector2f size) {
        this.initialize(size, DEFAULT_DIALOG_TITLE);
    }

    public Dialog(String title) {
        super(title);
        this.initialize(null, title);
    }

    public Dialog(String title, float width, float height) {
        this.initialize(new Vector2f(width, height), title);
    }

    public Dialog(String title, Vector2f size) {
        this.initialize(size, title);
    }

    private void initialize(Vector2f size, String title) {
        this.getTitleTextState().setText(title);
        if (size != null) {
            this.setSize(size);
        }
        this.setMinimizable(false);
        this.getListenerMap().addListener(WidgetCloseEvent.class, new DialogCloseEventListener(this));
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(Dialog.class).applyAll(this);
    }

    public void show(Frame frame) {
        this.frame = frame;
        if (this.frame != null) {
            Vector2f dialogLayerSize = new Vector2f((Vector2fc)frame.getContainer().getSize());
            this.setPosition((dialogLayerSize.x - this.getSize().x) / 2.0f, (dialogLayerSize.y - this.getSize().y) / 2.0f);
            this.frame.addLayer(this.dialogLayer);
            this.dialogLayer.setSize(dialogLayerSize);
            this.dialogLayer.add(this);
        }
    }

    public DialogLayer getDialogLayer() {
        return this.dialogLayer;
    }

    public void close() {
        if (this.frame != null) {
            this.frame.removeLayer(this.dialogLayer);
        }
    }

    public static class DialogLayer
    extends Layer {
        public DialogLayer() {
            this.setEventPassable(false);
            this.setEventReceivable(true);
            this.getStyle().getBackground().setColor(0.0f, 0.0f, 0.0f, 0.2f);
        }
    }
}

