/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.component.Layer;
import com.spinyowl.legui.component.Tooltip;
import com.spinyowl.legui.component.misc.listener.component.TabKeyEventListener;
import com.spinyowl.legui.component.misc.listener.component.TooltipCursorEnterListener;
import com.spinyowl.legui.event.AddChildEvent;
import com.spinyowl.legui.event.CursorEnterEvent;
import com.spinyowl.legui.event.KeyEvent;
import com.spinyowl.legui.event.RemoveChildEvent;
import com.spinyowl.legui.intersection.Intersector;
import com.spinyowl.legui.intersection.RectangleIntersector;
import com.spinyowl.legui.listener.ListenerMap;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.theme.Themes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public abstract class Component
implements Serializable {
    private final Map<String, Object> metadata = new HashMap<String, Object>();
    private final Style hoveredStyle = new Style();
    private final Style focusedStyle = new Style();
    private final Style pressedStyle = new Style();
    private final List<Component> childComponents = new CopyOnWriteArrayList<Component>();
    private Component parent;
    private ListenerMap listenerMap = new ListenerMap();
    private Vector2f position = new Vector2f();
    private Vector2f size = new Vector2f();
    private boolean enabled = true;
    private Intersector intersector = new RectangleIntersector();
    private boolean hovered;
    private boolean focused;
    private boolean pressed;
    private Tooltip tooltip;
    private int tabIndex;
    private boolean tabFocusable = true;
    private boolean focusable = true;
    private Style style = new Style();
    private boolean keepRendering;

    public Component() {
        this(0.0f, 0.0f, 10.0f, 10.0f);
    }

    public Component(float x, float y, float width, float height) {
        this(new Vector2f(x, y), new Vector2f(width, height));
    }

    public Component(Vector2f position, Vector2f size) {
        this.position = position;
        this.size = size;
        this.initialize();
    }

    public Style getFocusedStyle() {
        return this.focusedStyle;
    }

    public Style getHoveredStyle() {
        return this.hoveredStyle;
    }

    public Style getPressedStyle() {
        return this.pressedStyle;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        if (style != null) {
            this.style = style;
        }
    }

    private void initialize() {
        this.getListenerMap().addListener(CursorEnterEvent.class, new TooltipCursorEnterListener());
        this.getListenerMap().addListener(KeyEvent.class, new TabKeyEventListener());
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(Component.class).applyAll(this);
    }

    public Component getParent() {
        return this.parent;
    }

    public void setParent(Component parent) {
        if (parent == this) {
            return;
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.parent = parent;
        if (parent != null) {
            parent.add(this);
        }
    }

    public ListenerMap getListenerMap() {
        return this.listenerMap;
    }

    public void setListenerMap(ListenerMap listenerMap) {
        this.listenerMap = listenerMap;
    }

    public Vector2f getPosition() {
        return this.position;
    }

    public void setPosition(Vector2f position) {
        if (position != null) {
            this.position = position;
        } else {
            this.position.set(0.0f);
        }
    }

    public void setPosition(float x, float y) {
        this.position.set(x, y);
    }

    public Vector2f getSize() {
        return this.size;
    }

    public void setSize(Vector2f size) {
        if (size != null) {
            this.size = size;
        } else {
            this.size.set(0.0f);
        }
    }

    public void setSize(float width, float height) {
        this.size.set(width, height);
    }

    public Vector2f getAbsolutePosition() {
        Vector2f screenPos = new Vector2f((Vector2fc)this.position);
        for (Component p = this.getParent(); p != null; p = p.getParent()) {
            screenPos.add((Vector2fc)p.getPosition());
        }
        return screenPos;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isVisible() {
        return this.style.getDisplay() != Style.DisplayType.NONE;
    }

    public boolean intersects(Vector2f point) {
        return this.intersector.intersects(this, point);
    }

    public Intersector getIntersector() {
        return this.intersector;
    }

    public void setIntersector(Intersector intersector) {
        if (intersector == null) {
            return;
        }
        this.intersector = intersector;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public void setHovered(boolean hovered) {
        this.hovered = hovered;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(Tooltip tooltip) {
        if (this.tooltip == tooltip) {
            return;
        }
        if (this.tooltip != null) {
            Tooltip prev = this.tooltip;
            this.tooltip = null;
            prev.setComponent(null);
        }
        this.tooltip = tooltip;
        if (tooltip != null) {
            tooltip.setComponent(this);
        }
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public boolean isTabFocusable() {
        return this.tabFocusable;
    }

    public void setTabFocusable(boolean tabFocusable) {
        this.tabFocusable = tabFocusable;
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    public int count() {
        return this.childComponents.size();
    }

    public boolean isEmpty() {
        return this.childComponents.isEmpty();
    }

    public boolean contains(Component component) {
        return this.isContains(component);
    }

    public Iterator<Component> containerIterator() {
        return this.childComponents.iterator();
    }

    public boolean add(Component component) {
        if (component == null || component == this || this.isContains(component)) {
            return false;
        }
        boolean added = this.childComponents.add(component);
        this.changeParent(component);
        EventProcessorProvider.getInstance().pushEvent(new AddChildEvent<Component>(this, component));
        return added;
    }

    public void add(int index, Component component) {
        if (component == null || component == this || this.isContains(component)) {
            return;
        }
        this.childComponents.add(index, component);
        this.changeParent(component);
        EventProcessorProvider.getInstance().pushEvent(new AddChildEvent<Component>(this, component));
    }

    private boolean isContains(Component component) {
        return this.childComponents.stream().anyMatch(c -> c == component);
    }

    public void addAll(Collection<? extends Component> components) {
        if (components != null) {
            components.forEach(this::add);
        }
    }

    private void changeParent(Component component) {
        Component p = component.getParent();
        if (p == this) {
            return;
        }
        if (p != null) {
            p.remove(component);
        }
        component.setParent(this);
    }

    public boolean remove(Component component) {
        Component p;
        if (component != null && (p = component.getParent()) == this && this.isContains(component)) {
            boolean removed = this.childComponents.remove(component);
            component.setParent(null);
            EventProcessorProvider.getInstance().pushEvent(new RemoveChildEvent<Component>(this, component));
            return removed;
        }
        return false;
    }

    public Component remove(int index) {
        Component component = this.childComponents.remove(index);
        if (component != null) {
            component.setParent(null);
            EventProcessorProvider.getInstance().pushEvent(new RemoveChildEvent<Component>(this, component));
        }
        return component;
    }

    public void removeAll(Collection<? extends Component> components) {
        if (components != null) {
            components.forEach(this::remove);
        }
    }

    public void removeIf(Predicate<? super Component> filter) {
        this.childComponents.stream().filter(filter).forEach(this::remove);
    }

    public void clearChildComponents() {
        this.childComponents.forEach((? super T compo) -> compo.setParent(null));
        this.childComponents.clear();
    }

    public boolean containsAll(Collection<Component> components) {
        return this.childComponents.containsAll(components);
    }

    public Stream<Component> stream() {
        return this.childComponents.stream();
    }

    public Stream<Component> parallelStream() {
        return this.childComponents.parallelStream();
    }

    public void forEach(Consumer<? super Component> action) {
        this.childComponents.forEach(action);
    }

    public List<Component> getChildComponents() {
        return new ArrayList<Component>(this.childComponents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component component = (Component)o;
        return new EqualsBuilder().append(this.isEnabled(), component.isEnabled()).append(this.isVisible(), component.isVisible()).append(this.isHovered(), component.isHovered()).append(this.isFocused(), component.isFocused()).append(this.isPressed(), component.isPressed()).append((Object)this.getPosition(), (Object)component.getPosition()).append((Object)this.getSize(), (Object)component.getSize()).append((Object)this.getIntersector(), (Object)component.getIntersector()).append(this.getTabIndex(), component.getTabIndex()).append(this.isTabFocusable(), component.isTabFocusable()).append(this.isFocusable(), component.isFocusable()).append(this.childComponents, component.childComponents).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.position).append((Object)this.size).append(this.enabled).append((Object)this.intersector).append(this.hovered).append(this.focused).append(this.pressed).append(this.tabIndex).append(this.tabFocusable).append(this.focusable).append(this.childComponents).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("position", (Object)this.position).append("size", (Object)this.size).append("enabled", this.enabled).append("intersector", (Object)this.intersector).append("hovered", this.hovered).append("focused", this.focused).append("tabIndex", this.tabIndex).append("tabFocusable", this.tabFocusable).append("focusable", this.focusable).append("pressed", this.pressed).toString();
    }

    public int indexOfChild(Component component) {
        return this.childComponents.indexOf(component);
    }

    public Layer getLayer() {
        if (this.parent == null) {
            return null;
        }
        return this.parent instanceof Layer ? (Layer)this.parent : this.parent.getLayer();
    }

    public Frame getFrame() {
        return this.parent == null ? null : this.parent.getFrame();
    }

    public boolean keepRendering() {
        return this.keepRendering;
    }

    public void keepRendering(boolean keepRendering) {
        this.keepRendering = keepRendering;
    }
}

