/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.AbstractTextComponent;
import com.spinyowl.legui.component.event.button.ButtonContentChangeEvent;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.style.font.TextDirection;
import com.spinyowl.legui.theme.Themes;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;

public class Button
extends AbstractTextComponent {
    public static final String DEFAULT_BUTTON_TEXT = "Button";
    private TextDirection textDirection = TextDirection.HORIZONTAL;

    public Button() {
        this(DEFAULT_BUTTON_TEXT);
    }

    public Button(float x, float y, float width, float height) {
        this(DEFAULT_BUTTON_TEXT, x, y, width, height);
    }

    public Button(Vector2f position, Vector2f size) {
        this(DEFAULT_BUTTON_TEXT, position, size);
    }

    public Button(String text) {
        this.initialize(text);
    }

    public Button(String text, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize(text);
    }

    public Button(String text, Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize(text);
    }

    private void initialize(String text) {
        BiConsumer<String, String> callback = (oldValue, newValue) -> EventProcessorProvider.getInstance().pushEvent(new ButtonContentChangeEvent(this, null, this.getFrame(), (String)oldValue, (String)newValue));
        this.textState = new TextState(text, callback);
        this.getStyle().setHorizontalAlign(HorizontalAlign.CENTER);
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(Button.class).applyAll(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Button button = (Button)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getTextState(), (Object)button.getTextState()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.textState).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("textState", (Object)this.textState).toString();
    }

    public TextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(TextDirection textDirection) {
        this.textDirection = textDirection;
    }
}

