/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.animation;

import com.spinyowl.legui.animation.Animation;
import com.spinyowl.legui.animation.Animator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lwjgl.glfw.GLFW;

public class AnimatorImpl
implements Animator {
    private List<Animation> animationsToInitialize = new CopyOnWriteArrayList<Animation>();
    private List<Animation> animations = new CopyOnWriteArrayList<Animation>();
    private List<Animation> animationsToDestroy = new CopyOnWriteArrayList<Animation>();
    private List<Animation> animationsToRemove = new CopyOnWriteArrayList<Animation>();
    private double previousTime;

    @Override
    public void runAnimations() {
        double currentTime = GLFW.glfwGetTime();
        double delta = currentTime - this.previousTime;
        ArrayList<Animation> initializeList = new ArrayList<Animation>(this.animationsToInitialize);
        for (Animation animation : initializeList) {
            animation.beforeAnimation();
            this.animationsToInitialize.remove(animation);
            this.animations.add(animation);
        }
        ArrayList<Animation> processList = new ArrayList<Animation>(this.animations);
        for (Animation animation : processList) {
            if (this.animationsToRemove.contains(animation)) {
                this.animationsToRemove.remove(animation);
                this.animations.remove(animation);
                this.animationsToDestroy.add(animation);
                continue;
            }
            if (!animation.animate(delta)) continue;
            this.animations.remove(animation);
            this.animationsToDestroy.add(animation);
        }
        ArrayList<Animation> arrayList = new ArrayList<Animation>(this.animationsToDestroy);
        for (Animation animation : arrayList) {
            animation.afterAnimation();
            this.animationsToDestroy.remove(animation);
        }
        this.previousTime = currentTime;
    }

    @Override
    public void pushAnimation(Animation animation) {
        this.animationsToInitialize.add(animation);
    }

    @Override
    public void removeAnimation(Animation animation) {
        this.animationsToRemove.add(animation);
    }
}

