/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.util;

import com.spinyowl.legui.component.Component;
import java.util.ArrayList;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public final class Utilites {
    private Utilites() {
    }

    public static boolean visibleInParents(Component component) {
        ArrayList<Component> parentList = new ArrayList<Component>();
        for (Component parent = component.getParent(); parent != null; parent = parent.getParent()) {
            parentList.add(parent);
        }
        if (parentList.size() > 0) {
            Vector2f pos = new Vector2f(0.0f, 0.0f);
            Vector2f rect = new Vector2f(0.0f, 0.0f);
            Vector2f absolutePosition = component.getAbsolutePosition();
            Vector2f cSize = component.getSize();
            Vector2f cPos = component.getPosition();
            float lx = absolutePosition.x;
            float rx = absolutePosition.x + cSize.x;
            float ty = absolutePosition.y;
            float by = absolutePosition.y + cSize.y;
            if (cPos.x > component.getParent().getSize().x || cPos.x + cSize.x < 0.0f || cPos.y > component.getParent().getSize().y || cPos.y + cSize.y < 0.0f) {
                return false;
            }
            if (parentList.size() != 1) {
                for (int i = parentList.size() - 1; i >= 1; --i) {
                    Component parent = (Component)parentList.get(i);
                    pos.add((Vector2fc)parent.getPosition());
                    rect.set((Vector2fc)pos).add((Vector2fc)parent.getSize());
                    if (!(lx > rect.x || rx < pos.x || ty > rect.y) && !(by < pos.y)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

