/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.util;

import java.util.Arrays;

public class TextUtil {
    private static char[] wordBreakers = new char[]{' ', ',', '.', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '-', '=', '+', '`', '~', ';', ':', '\"', '\'', '/', '?', '\\', '[', ']', '{', '}', '<', '>', '|', '\n', '\r', '\t'};

    private TextUtil() {
    }

    public static int findNextWord(String text, int current) {
        int next;
        int length = text.length();
        if (current == length) {
            return length;
        }
        boolean startedWord = false;
        for (next = current; next < length; ++next) {
            boolean word;
            int i = Arrays.binarySearch(wordBreakers, text.charAt(next));
            if (i < 0) {
                word = true;
                startedWord = true;
            } else {
                word = false;
            }
            if (!word && startedWord) break;
        }
        return next;
    }

    public static int findPrevWord(String text, int current) {
        int prev;
        if (current == 0) {
            return 0;
        }
        boolean startedWord = false;
        for (prev = current; prev > 0; --prev) {
            boolean word;
            int i = Arrays.binarySearch(wordBreakers, text.charAt(prev - 1));
            if (i < 0) {
                word = true;
                startedWord = true;
            } else {
                word = false;
            }
            if (!word && startedWord) break;
        }
        return prev;
    }

    public static String cpToStr(int cp) {
        return new String(Character.toChars(cp));
    }

    static {
        Arrays.sort(wordBreakers);
    }
}

