/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.util;

import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.style.font.TextDirection;
import com.spinyowl.legui.system.renderer.nvg.util.NvgColorUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.joml.Vector2f;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NVGTextRow;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;

public class NvgText {
    public static final double THRESHOLD = 0.001;
    public static final float _90 = 1.5707964f;
    public static final float _270 = 4.712389f;

    private NvgText() {
    }

    public static void drawTextLineToRect(long nvg, Vector4fc rect, boolean hideOverflow, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, float fontSize, String font, String textToRender, Vector4f fontColor) {
        NvgText.drawTextLineToRect(nvg, rect, hideOverflow, horizontalAlign, verticalAlign, fontSize, font, textToRender, fontColor, TextDirection.HORIZONTAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawTextLineToRect(long nvg, Vector4fc rect, boolean hideOverflow, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, float fontSize, String font, String textToRender, Vector4f fontColor, TextDirection direction) {
        block24: {
            if (textToRender.length() == 0) {
                return;
            }
            NanoVG.nvgFontSize((long)nvg, (float)fontSize);
            NanoVG.nvgFontFace((long)nvg, (CharSequence)font);
            NvgText.textAlign(nvg, horizontalAlign, verticalAlign);
            ByteBuffer byteText = null;
            try {
                byteText = MemoryUtil.memUTF8((CharSequence)textToRender, (boolean)false);
                long startPointer = MemoryUtil.memAddress((ByteBuffer)byteText);
                long endPointer = startPointer + (long)byteText.remaining();
                long rowStart = startPointer;
                long rowEnd = endPointer;
                if (hideOverflow) {
                    try (NVGTextRow.Buffer buffer = NVGTextRow.calloc((int)1);){
                        int rows = NanoVG.nnvgTextBreakLines((long)nvg, (long)startPointer, (long)endPointer, (float)(direction == TextDirection.HORIZONTAL ? rect.z() : rect.w()), (long)MemoryUtil.memAddress((CustomBuffer)buffer), (int)1);
                        if (rows != 0) {
                            NVGTextRow row = (NVGTextRow)buffer.get(0);
                            rowStart = row.start();
                            rowEnd = row.end();
                        }
                    }
                }
                Vector2f textPosition = new Vector2f(rect.x() + rect.z() * (float)horizontalAlign.index / 2.0f, rect.y() + rect.w() * (float)verticalAlign.index / 2.0f);
                if (rowStart == 0L && rowEnd == 0L) break block24;
                try (NVGColor textColor = NvgColorUtil.create((Vector4fc)fontColor);){
                    float y;
                    float x;
                    NanoVG.nvgSave((long)nvg);
                    NanoVG.nvgBeginPath((long)nvg);
                    NanoVG.nvgFillColor((long)nvg, (NVGColor)textColor);
                    if (direction == TextDirection.VERTICAL_TOP_DOWN) {
                        NanoVG.nvgTranslate((long)nvg, (float)(rect.x() + rect.z()), (float)rect.y());
                        NanoVG.nvgRotate((long)nvg, (float)1.5707964f);
                        x = rect.w() * (float)horizontalAlign.index / 2.0f;
                        y = rect.z() * (float)verticalAlign.index / 2.0f;
                    } else if (direction == TextDirection.VERTICAL_DOWN_TOP) {
                        NanoVG.nvgTranslate((long)nvg, (float)rect.x(), (float)(rect.y() + rect.w()));
                        NanoVG.nvgRotate((long)nvg, (float)4.712389f);
                        x = rect.w() * (float)horizontalAlign.index / 2.0f;
                        y = rect.z() * (float)verticalAlign.index / 2.0f;
                    } else {
                        NanoVG.nvgTranslate((long)nvg, (float)rect.x(), (float)rect.y());
                        x = textPosition.x - rect.x();
                        y = (float)((int)textPosition.y) - rect.y();
                    }
                    NanoVG.nnvgText((long)nvg, (float)((int)x), (float)((int)y), (long)rowStart, (long)rowEnd);
                    NanoVG.nvgRestore((long)nvg);
                }
            }
            finally {
                if (byteText != null) {
                    MemoryUtil.memFree((Buffer)byteText);
                }
            }
        }
    }

    public static void textAlign(long context, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign) {
        int nvgHorizontalAlign = 0;
        int nvgVerticalAlign = 0;
        switch (horizontalAlign) {
            case LEFT: {
                nvgHorizontalAlign = 1;
                break;
            }
            case RIGHT: {
                nvgHorizontalAlign = 4;
                break;
            }
            case CENTER: {
                nvgHorizontalAlign = 2;
            }
        }
        switch (verticalAlign) {
            case TOP: {
                nvgVerticalAlign = 8;
                break;
            }
            case BOTTOM: {
                nvgVerticalAlign = 32;
                break;
            }
            case MIDDLE: {
                nvgVerticalAlign = 16;
                break;
            }
            case BASELINE: {
                nvgVerticalAlign = 64;
            }
        }
        NanoVG.nvgTextAlign((long)context, (int)(nvgHorizontalAlign | nvgVerticalAlign));
    }
}

