/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.util;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.shadow.Shadow;
import com.spinyowl.legui.style.util.StyleUtilities;
import com.spinyowl.legui.system.renderer.nvg.util.NvgColorUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NVGPaint;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.system.MemoryUtil;

public final class NvgRenderUtils {
    private NvgRenderUtils() {
    }

    public static float[] calculateTextBoundsRect(long context, Vector4f rect, String text, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, float fontSize) {
        return NvgRenderUtils.calculateTextBoundsRect(context, rect.x, rect.y, rect.z, rect.w, text, horizontalAlign, verticalAlign, fontSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float[] calculateTextBoundsRect(long context, float x, float y, float w, float h, String text, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, float fontSize) {
        ByteBuffer byteText = null;
        try {
            byteText = MemoryUtil.memUTF8((CharSequence)text, (boolean)false);
            float[] fArray = NvgRenderUtils.calculateTextBoundsRect(context, x, y, w, h, byteText, horizontalAlign, verticalAlign, fontSize);
            return fArray;
        }
        finally {
            if (byteText != null) {
                MemoryUtil.memFree((Buffer)byteText);
            }
        }
    }

    public static float[] calculateTextBoundsRect(long context, float x, float y, float w, float h, ByteBuffer text, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, float fontSize) {
        float[] bounds = new float[4];
        if (text != null && text.limit() != 0) {
            NanoVG.nvgTextBounds((long)context, (float)x, (float)y, (ByteBuffer)text, (float[])bounds);
            return NvgRenderUtils.createBounds(x, y, w, h, horizontalAlign, verticalAlign, bounds);
        }
        return NvgRenderUtils.createBounds(x, y, w, h, horizontalAlign, verticalAlign, 0.0f, fontSize);
    }

    public static float[] createBounds(float x, float y, float w, float h, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, float[] bounds) {
        float ww = bounds[2] - bounds[0];
        float hh = bounds[3] - bounds[1];
        return NvgRenderUtils.createBounds(x, y, w, h, horizontalAlign, verticalAlign, ww, hh);
    }

    public static float[] createBounds(float w, float h, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, float[] bounds, float ww, float hh) {
        int vp;
        int hp;
        switch (horizontalAlign) {
            case LEFT: {
                hp = 0;
                break;
            }
            case CENTER: {
                hp = 1;
                break;
            }
            default: {
                hp = 2;
            }
        }
        switch (verticalAlign) {
            case TOP: {
                vp = 0;
                break;
            }
            case MIDDLE: {
                vp = 1;
                break;
            }
            default: {
                vp = verticalAlign == VerticalAlign.BOTTOM ? 2 : 3;
            }
        }
        float x1 = bounds[0] + (w + ww) * 0.5f * (float)hp;
        float baseline = vp > 2 ? hh / 4.0f : 0.0f;
        float vv = vp == 3 ? 1 : vp;
        float y1 = bounds[1] + (h + hh) * 0.5f * vv + (vp > 2 ? baseline : 0.0f);
        return new float[]{x1, y1, ww, hh, x1 - ww * 0.5f * (float)hp, y1 - hh * 0.5f * vv - baseline, ww, hh};
    }

    public static float[] createBounds(float x, float y, float w, float h, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, float tw, float th) {
        int hp = horizontalAlign.index;
        int vp = verticalAlign.index;
        float x1 = x + w * 0.5f * (float)hp;
        float baseline = vp > 2 ? th / 4.0f : 0.0f;
        float vv = vp == 3 ? 1 : vp;
        float y1 = y + h * 0.5f * vv + (vp > 2 ? baseline : 0.0f);
        return new float[]{x1, y1, tw, th, x1 - tw * 0.5f * (float)hp, y1 - th * 0.5f * vv - baseline, tw, th};
    }

    public static void alignTextInBox(long context, HorizontalAlign hAlig, VerticalAlign vAlig) {
        int vAlign;
        int hAlign;
        switch (hAlig) {
            case CENTER: {
                hAlign = 2;
                break;
            }
            case LEFT: {
                hAlign = 1;
                break;
            }
            default: {
                hAlign = 4;
            }
        }
        switch (vAlig) {
            case TOP: {
                vAlign = 8;
                break;
            }
            case BOTTOM: {
                vAlign = 32;
                break;
            }
            case MIDDLE: {
                vAlign = 16;
                break;
            }
            default: {
                vAlign = 64;
            }
        }
        NanoVG.nvgTextAlign((long)context, (int)(hAlign | vAlign));
    }

    public static void createScissor(long context, Component gui) {
        Component parent = gui.getParent();
        NvgRenderUtils.createScissorByParent(context, parent);
    }

    public static void createScissor(long context, Vector4f bounds) {
        NanoVG.nvgScissor((long)context, (float)bounds.x, (float)bounds.y, (float)bounds.z, (float)bounds.w);
    }

    public static void intersectScissor(long context, Vector4f bounds) {
        NanoVG.nvgIntersectScissor((long)context, (float)bounds.x, (float)bounds.y, (float)bounds.z, (float)bounds.w);
    }

    public static void createScissorByParent(long context, Component parent) {
        ArrayList<Component> parents = new ArrayList<Component>();
        while (parent != null) {
            parents.add(parent);
            parent = parent.getParent();
        }
        Vector2f pos = new Vector2f();
        int size = parents.size();
        if (size > 0) {
            parent = (Component)parents.get(size - 1);
            pos.add((Vector2fc)parent.getPosition());
            Vector2f s = parent.getSize();
            NvgRenderUtils.createScissor(context, new Vector4f((Vector2fc)pos, s.x, s.y));
            if (size > 1) {
                for (int i = size - 2; i >= 0; --i) {
                    parent = (Component)parents.get(i);
                    s = parent.getSize();
                    pos.add((Vector2fc)parent.getPosition());
                    NanoVG.nvgIntersectScissor((long)context, (float)pos.x, (float)pos.y, (float)s.x, (float)s.y);
                }
            }
        }
    }

    public static void resetScissor(long context) {
        NanoVG.nvgResetScissor((long)context);
    }

    public static void runWithScissor(long context, Component parent, Runnable runnable) {
        NvgRenderUtils.createScissorByParent(context, parent);
        runnable.run();
        NvgRenderUtils.resetScissor(context);
    }

    public static Vector4f getBorderRadius(Component component) {
        Style style = component.getStyle();
        Vector4f r = StyleUtilities.getBorderRadius(component, style);
        if (component.isFocused()) {
            NvgRenderUtils.applyCurrentRadius(r, component, component.getFocusedStyle());
        }
        if (component.isHovered()) {
            NvgRenderUtils.applyCurrentRadius(r, component, component.getHoveredStyle());
        }
        if (component.isPressed()) {
            NvgRenderUtils.applyCurrentRadius(r, component, component.getPressedStyle());
        }
        return r;
    }

    private static void applyCurrentRadius(Vector4f r, Component component, Style curr) {
        if (curr.getBorderTopLeftRadius() != null) {
            r.x = StyleUtilities.getFloatLengthNullSafe(curr.getBorderTopLeftRadius(), component.getSize().x);
        }
        if (curr.getBorderTopRightRadius() != null) {
            r.x = StyleUtilities.getFloatLengthNullSafe(curr.getBorderTopRightRadius(), component.getSize().x);
        }
        if (curr.getBorderBottomRightRadius() != null) {
            r.x = StyleUtilities.getFloatLengthNullSafe(curr.getBorderBottomRightRadius(), component.getSize().x);
        }
        if (curr.getBorderBottomLeftRadius() != null) {
            r.x = StyleUtilities.getFloatLengthNullSafe(curr.getBorderBottomLeftRadius(), component.getSize().x);
        }
    }

    public static void renderShadow(long context, Component component) {
        Shadow shadow = component.getStyle().getShadow();
        if (shadow != null && shadow.getColor() != null && shadow.getColor().w > 0.01f) {
            float hOffset = shadow.gethOffset();
            float vOffset = shadow.getvOffset();
            float blur = shadow.getBlur();
            float spread = shadow.getSpread();
            Vector2f absolutePosition = component.getAbsolutePosition();
            Vector2f size = component.getSize();
            float x = absolutePosition.x;
            float y = absolutePosition.y;
            float w = size.x;
            float h = size.y;
            Vector4f borderRadius = NvgRenderUtils.getBorderRadius(component);
            float cornerRadius = (borderRadius.x + borderRadius.y + borderRadius.z + borderRadius.w) / 4.0f;
            try (NVGPaint shadowPaint = NVGPaint.calloc();
                 NVGColor firstColor = NvgColorUtil.create((Vector4fc)shadow.getColor());
                 NVGColor secondColor = NvgColorUtil.create(0.0f, 0.0f, 0.0f, 0.0f);){
                NanoVG.nvgBoxGradient((long)context, (float)(x + hOffset - spread), (float)(y + vOffset - spread), (float)(w + 2.0f * spread), (float)(h + 2.0f * spread), (float)(cornerRadius + spread), (float)blur, (NVGColor)firstColor, (NVGColor)secondColor, (NVGPaint)shadowPaint);
                NanoVG.nvgBeginPath((long)context);
                NanoVG.nvgRoundedRectVarying((long)context, (float)(x + hOffset - spread - blur), (float)(y + vOffset - spread - blur), (float)(w + 2.0f * spread + 2.0f * blur), (float)(h + 2.0f * spread + 2.0f * blur), (float)(borderRadius.x + spread), (float)(borderRadius.y + spread), (float)(borderRadius.z + spread), (float)(borderRadius.w + spread));
                NanoVG.nvgRoundedRectVarying((long)context, (float)x, (float)y, (float)w, (float)h, (float)borderRadius.x, (float)borderRadius.y, (float)borderRadius.z, (float)borderRadius.w);
                NanoVG.nvgPathWinding((long)context, (int)2);
                NanoVG.nvgFillPaint((long)context, (NVGPaint)shadowPaint);
                NanoVG.nvgFill((long)context);
            }
        }
        NanoVG.nvgRestore((long)context);
    }
}

