/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.image;

import com.spinyowl.legui.image.FBOImage;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.NvgImageReferenceManager;
import com.spinyowl.legui.system.renderer.nvg.NvgImageRenderer;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.IntFunction;
import org.joml.Vector2fc;
import org.lwjgl.nanovg.NanoVGGL2;
import org.lwjgl.nanovg.NanoVGGL3;
import org.lwjgl.opengl.GL11;

public class NvgFBOImageRenderer
extends NvgImageRenderer<FBOImage> {
    @Override
    public void initialize() {
        NvgImageReferenceManager manager = NvgImageReferenceManager.getInstance();
        manager.putImageReferenceProvider(FBOImage.class, (i, c) -> {
            IntFunction<String> getFboPath = textureId -> "::FBO::" + textureId;
            int textureId2 = i.getTextureId();
            Integer imageRef = 0;
            if (textureId2 != 0) {
                String path = getFboPath.apply(textureId2);
                try {
                    imageRef = (Integer)manager.getImageCache().get((Object)path, this.createReference(manager, (FBOImage)i, (Long)c, getFboPath));
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            } else {
                return 0;
            }
            return imageRef;
        });
    }

    private Callable<Integer> createReference(NvgImageReferenceManager manager, FBOImage i, Long c, IntFunction<String> getFboPath) {
        return () -> {
            int handle = i.getTextureId();
            int width = i.getWidth();
            int height = i.getHeight();
            boolean isVersionNew = GL11.glGetInteger((int)33307) > 3 || GL11.glGetInteger((int)33307) == 3 && GL11.glGetInteger((int)33308) >= 2;
            int reference = isVersionNew ? NanoVGGL3.nvglCreateImageFromHandle((long)c, (int)handle, (int)width, (int)height, (int)0) : NanoVGGL2.nvglCreateImageFromHandle((long)c, (int)handle, (int)width, (int)height, (int)0);
            manager.getImageAssociationMap().put((String)getFboPath.apply(handle), reference);
            return reference;
        };
    }

    @Override
    protected void renderImage(FBOImage image, Vector2fc position, Vector2fc size, Map<String, Object> properties, Context context, long nanovg) {
        NvgImageReferenceManager manager = NvgImageReferenceManager.getInstance();
        int imageRef = manager.getImageReference(image, nanovg);
        this.renderImage(imageRef, position, size, properties, nanovg);
    }
}

