/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.icon;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.icon.CharIcon;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.NvgIconRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgText;
import com.spinyowl.legui.util.TextUtil;
import org.joml.Vector2f;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class NvgCharIconRenderer<I extends CharIcon>
extends NvgIconRenderer<I> {
    @Override
    protected void renderIcon(I icon, Component component, Context context, long nanovg) {
        if (!component.isVisible() || icon == null || ((CharIcon)icon).getFont() == null) {
            return;
        }
        Vector2f iconSize = ((Icon)icon).getSize();
        Vector2f p = this.calculateIconPosition(icon, component, iconSize);
        float w = iconSize.x;
        float h = iconSize.y;
        this.drawIcon(nanovg, p.x, p.y, w, h, (CharIcon)icon, component);
    }

    private void drawIcon(long context, float x, float y, float w, float h, CharIcon icon, Component component) {
        Vector4f focusedStrokeColor;
        if (component.isFocused() && (focusedStrokeColor = component.getStyle().getFocusedStrokeColor()) != null) {
            NvgText.drawTextLineToRect(context, (Vector4fc)new Vector4f(x - 0.5f, y + 1.0f, w, h), false, icon.getHorizontalAlign(), icon.getVerticalAlign(), icon.getSize().y, icon.getFont(), TextUtil.cpToStr(icon.getCharCode()), focusedStrokeColor);
        }
        NvgText.drawTextLineToRect(context, (Vector4fc)new Vector4f(x + 0.5f, y, w, h), false, icon.getHorizontalAlign(), icon.getVerticalAlign(), icon.getSize().y, icon.getFont(), TextUtil.cpToStr(icon.getCharCode()), icon.getColor());
    }
}

