/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.component;

import com.spinyowl.legui.component.Tooltip;
import com.spinyowl.legui.component.event.tooltip.TooltipTextSizeChangeEvent;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.font.FontRegistry;
import com.spinyowl.legui.style.util.StyleUtilities;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.component.NvgDefaultComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgColorUtil;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.joml.Vector2f;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NVGTextRow;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;

public class NvgTooltipRenderer
extends NvgDefaultComponentRenderer<Tooltip> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderSelf(Tooltip component, Context context, long nanovg) {
        NvgRenderUtils.createScissor(nanovg, component);
        Style style = component.getStyle();
        TextState textState = component.getTextState();
        Vector2f pos = component.getAbsolutePosition();
        Vector2f size = component.getSize();
        float fontSize = StyleUtilities.getStyle(component, Style::getFontSize, Float.valueOf(16.0f)).floatValue();
        String font = StyleUtilities.getStyle(component, Style::getFont, FontRegistry.getDefaultFont());
        String text = textState.getText();
        HorizontalAlign horizontalAlign = StyleUtilities.getStyle(component, Style::getHorizontalAlign, HorizontalAlign.LEFT);
        VerticalAlign verticalAlign = StyleUtilities.getStyle(component, Style::getVerticalAlign, VerticalAlign.MIDDLE);
        Vector4f textColor = StyleUtilities.getStyle(component, Style::getTextColor);
        Vector4f padding = StyleUtilities.getPadding(component, style);
        this.renderBackground(component, context, nanovg);
        NanoVG.nvgFontSize((long)nanovg, (float)fontSize);
        NanoVG.nvgFontFace((long)nanovg, (CharSequence)font);
        ByteBuffer byteText = null;
        try {
            byteText = MemoryUtil.memUTF8((CharSequence)text, (boolean)false);
            long start = MemoryUtil.memAddress((ByteBuffer)byteText);
            long end = start + (long)byteText.remaining();
            float x = pos.x + padding.x;
            float y = pos.y + padding.y;
            float w = size.x - padding.x - padding.z;
            float h = size.y - padding.y - padding.w;
            NvgRenderUtils.intersectScissor(nanovg, new Vector4f(x, y, w, h));
            ArrayList<float[]> boundList = new ArrayList<float[]>();
            ArrayList<long[]> indicesList = new ArrayList<long[]>();
            try (NVGColor colorA = NvgColorUtil.create((Vector4fc)textColor);
                 NVGTextRow.Buffer buffer = NVGTextRow.calloc((int)1);){
                NvgRenderUtils.alignTextInBox(nanovg, HorizontalAlign.LEFT, VerticalAlign.MIDDLE);
                NanoVG.nvgFontSize((long)nanovg, (float)fontSize);
                NanoVG.nvgFontFace((long)nanovg, (CharSequence)font);
                NanoVG.nvgFillColor((long)nanovg, (NVGColor)colorA);
                float newWidth = 0.0f;
                float newHeight = 0.0f;
                int rows = 0;
                while (NanoVG.nnvgTextBreakLines((long)nanovg, (long)start, (long)end, (float)size.x, (long)MemoryUtil.memAddress((CustomBuffer)buffer), (int)1) != 0) {
                    NVGTextRow row = (NVGTextRow)buffer.get(0);
                    float[] bounds = NvgRenderUtils.createBounds(x, y + (float)rows * fontSize, w, h, horizontalAlign, verticalAlign, row.width(), fontSize);
                    boundList.add(bounds);
                    newWidth = Math.max(row.width(), newWidth);
                    indicesList.add(new long[]{row.start(), row.end()});
                    start = row.next();
                    ++rows;
                }
                newHeight = (float)rows * fontSize;
                float textWidth = textState.getTextWidth();
                float textHeight = textState.getTextHeight();
                textState.setTextWidth(newWidth);
                textState.setTextHeight(newHeight);
                if ((double)Math.abs(textWidth - newWidth) > 0.001 || (double)Math.abs(textHeight - newHeight) > 0.001) {
                    EventProcessorProvider.getInstance().pushEvent(new TooltipTextSizeChangeEvent(component, context, component.getFrame(), newWidth, newHeight));
                }
                float offsetY = 0.5f * fontSize * (float)((rows - 1) * verticalAlign.index - 1);
                for (int i = 0; i < rows; ++i) {
                    float[] bounds = (float[])boundList.get(i);
                    long[] indices = (long[])indicesList.get(i);
                    NanoVG.nvgBeginPath((long)nanovg);
                    NanoVG.nnvgText((long)nanovg, (float)bounds[4], (float)(bounds[5] - offsetY), (long)indices[0], (long)indices[1]);
                }
            }
        }
        finally {
            MemoryUtil.memFree((Buffer)byteText);
        }
        NvgRenderUtils.resetScissor(nanovg);
    }
}

