/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.component;

import com.spinyowl.legui.component.ToggleButton;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.font.FontRegistry;
import com.spinyowl.legui.style.util.StyleUtilities;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.NvgRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgDefaultComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import com.spinyowl.legui.system.renderer.nvg.util.NvgShapes;
import com.spinyowl.legui.system.renderer.nvg.util.NvgText;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.nanovg.NanoVG;

public class NvgToggleButtonRenderer
extends NvgDefaultComponentRenderer<ToggleButton> {
    @Override
    protected void renderSelf(ToggleButton component, Context context, long nanovg) {
        NvgRenderUtils.createScissor(nanovg, component);
        Vector2f pos = component.getAbsolutePosition();
        Vector2f size = component.getSize();
        this.renderBackground(nanovg, component, pos, size, context);
        NanoVG.nvgIntersectScissor((long)nanovg, (float)pos.x, (float)pos.y, (float)size.x, (float)size.y);
        TextState text = component.getTextState();
        Vector4f rect = new Vector4f((Vector2fc)pos, size.x, size.y);
        NvgText.drawTextLineToRect(nanovg, (Vector4fc)rect, true, StyleUtilities.getStyle(component, Style::getHorizontalAlign, HorizontalAlign.LEFT), StyleUtilities.getStyle(component, Style::getVerticalAlign, VerticalAlign.MIDDLE), StyleUtilities.getStyle(component, Style::getFontSize, Float.valueOf(16.0f)).floatValue(), StyleUtilities.getStyle(component, Style::getFont, FontRegistry.getDefaultFont()), text.getText(), StyleUtilities.getStyle(component, Style::getTextColor));
        NvgRenderUtils.resetScissor(nanovg);
    }

    private void renderBackground(long nvg, ToggleButton agui, Vector2f pos, Vector2f size, Context context) {
        Icon icon = StyleUtilities.getStyle(agui, s -> s.getBackground().getIcon());
        Vector4f bgColor = StyleUtilities.getStyle(agui, s -> s.getBackground().getColor());
        Vector4f cornerRadius = NvgRenderUtils.getBorderRadius(agui);
        NvgRenderUtils.renderShadow(nvg, agui);
        boolean toggled = agui.isToggled();
        if (toggled) {
            NvgShapes.drawRect(nvg, (Vector2fc)pos, (Vector2fc)size, (Vector4fc)agui.getToggledBackgroundColor(), cornerRadius);
        } else {
            NvgShapes.drawRect(nvg, (Vector2fc)pos, (Vector2fc)size, (Vector4fc)bgColor, cornerRadius);
        }
        if (icon != null) {
            NvgRenderUtils.createScissorByParent(nvg, agui);
            NvgRenderer.renderIcon(icon, agui, context);
        }
    }
}

