/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.component;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.TextAreaField;
import com.spinyowl.legui.component.event.textarea.TextAreaFieldHeightChangeEvent;
import com.spinyowl.legui.component.event.textarea.TextAreaFieldWidthChangeEvent;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.input.Mouse;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.color.ColorUtil;
import com.spinyowl.legui.style.font.FontRegistry;
import com.spinyowl.legui.style.util.StyleUtilities;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.component.NvgDefaultComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgColorUtil;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import com.spinyowl.legui.system.renderer.nvg.util.NvgShapes;
import com.spinyowl.legui.system.renderer.nvg.util.NvgText;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NVGGlyphPosition;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;

public class NvgTextAreaFieldRenderer
extends NvgDefaultComponentRenderer<TextAreaField> {
    public static final String NEWLINE = "\n";
    private static final String TABS = "\t";
    private static final String SPACES = " ";
    private static final char SPACEC = ' ';
    private static final int MAX_GLYPH_COUNT = 2048;
    private final Vector4f caretColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.5f);

    @Override
    public void renderSelf(TextAreaField component, Context context, long nanovg) {
        NvgRenderUtils.runWithScissor(nanovg, component, () -> {
            Vector2f pos = component.getAbsolutePosition();
            Vector2f size = component.getSize();
            Style style = component.getStyle();
            Vector4f backgroundColor = new Vector4f((Vector4fc)style.getBackground().getColor());
            this.renderBackground(component, context, nanovg);
            Vector4f padding = StyleUtilities.getPadding(component, style);
            Vector4f textRect = StyleUtilities.getInnerContentRectangle(pos, size, padding);
            Component parent = component.getParent();
            Vector4f viewportRect = null;
            if (parent != null) {
                Vector2f pSize = parent.getSize();
                viewportRect = new Vector4f((Vector2fc)parent.getAbsolutePosition(), pSize.x, pSize.y);
            }
            NvgRenderUtils.intersectScissor(nanovg, new Vector4f((Vector4fc)textRect));
            this.renderText(context, nanovg, component, textRect, viewportRect, backgroundColor);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderText(Context leguiContext, long context, TextAreaField gui, Vector4f rect, Vector4f viewportRect, Vector4f bc) {
        String font = StyleUtilities.getStyle(gui, Style::getFont, FontRegistry.getDefaultFont());
        if (NanoVG.nvgFindFont((long)context, (CharSequence)font) == -1) {
            font = FontRegistry.getDefaultFont();
        }
        try (NVGGlyphPosition.Buffer glyphs = NVGGlyphPosition.calloc((int)2048);){
            int endSelectionIndex;
            int startSelectionIndex;
            float llineY;
            int vp;
            TextState textState = gui.getTextState();
            float fontSize = StyleUtilities.getStyle(gui, Style::getFontSize, Float.valueOf(16.0f)).floatValue();
            HorizontalAlign halign = StyleUtilities.getStyle(gui, Style::getHorizontalAlign, HorizontalAlign.LEFT);
            VerticalAlign valign = StyleUtilities.getStyle(gui, Style::getVerticalAlign, VerticalAlign.MIDDLE);
            Vector4f textColor = StyleUtilities.getStyle(gui, Style::getTextColor);
            int caretPosition = gui.getCaretPosition();
            boolean focused = gui.isFocused();
            int caretLine = 0;
            this.preinitializeTextRendering(context, font, fontSize, halign, valign, textColor);
            float spaceWidth = this.getSpaceWidth(context);
            String[] lines = textState.getText().split(NEWLINE, -1);
            int lineCount = lines.length;
            int[] lineStartIndeces = new int[lineCount];
            int caretOffset = 0;
            for (int i = 0; i < lineCount - 1; ++i) {
                lineStartIndeces[i + 1] = lineStartIndeces[i] + lines[i].length() + 1;
                if (caretPosition < lineStartIndeces[i + 1]) continue;
                caretOffset = lineStartIndeces[i + 1];
                caretLine = i + 1;
            }
            int lineCaretPosition = caretPosition - caretOffset;
            if (!focused && gui.isStickToAlignment()) {
                switch (valign) {
                    case TOP: {
                        caretLine = 0;
                        break;
                    }
                    case BOTTOM: {
                        caretLine = lineCount - 1;
                        break;
                    }
                    default: {
                        caretLine = lineCount / 2;
                    }
                }
                switch (halign) {
                    case LEFT: {
                        lineCaretPosition = 0;
                        break;
                    }
                    case RIGHT: {
                        lineCaretPosition = lines[caretLine].length();
                        break;
                    }
                    default: {
                        lineCaretPosition = lines[caretLine].length() / 2;
                    }
                }
            }
            switch (valign) {
                case TOP: {
                    vp = 0;
                    break;
                }
                case MIDDLE: {
                    vp = 1;
                    break;
                }
                default: {
                    vp = valign == VerticalAlign.BOTTOM ? 2 : 1;
                }
            }
            float voffset = (float)(lineCount - 1) * fontSize * (float)vp * -0.5f + (valign == VerticalAlign.BASELINE ? fontSize / 4.0f : 0.0f);
            float mouseCaretX = 0.0f;
            int mouseLineIndex = 0;
            int mouseCaretPositionInLine = 0;
            Vector2f cursorPosition = Mouse.getCursorPosition();
            float mouseX = cursorPosition.x;
            float mouseY = cursorPosition.y;
            String caretLineText = lines[caretLine];
            float[] caretLineBounds = NvgRenderUtils.calculateTextBoundsRect(context, rect, caretLineText, halign, valign, fontSize);
            float caretx = this.getCaretx(context, lineCaretPosition, caretLineText, caretLineBounds, glyphs, spaceWidth, gui.getTabSize());
            this.preinitializeTextRendering(context, font, fontSize, halign, valign, textColor);
            float[][] bounds = new float[lineCount][8];
            float maxWid = 0.0f;
            int first = 0;
            int last = lineCount - 1;
            if (viewportRect != null) {
                int mid = (first + last) / 2;
                while (first <= last) {
                    String line = lines[mid];
                    float[] lineBounds = NvgRenderUtils.calculateTextBoundsRect(context, rect, line, halign, valign, fontSize);
                    bounds[mid] = lineBounds;
                    float lineY = lineBounds[5] + voffset + fontSize * (float)mid;
                    float lineHeight = lineBounds[7];
                    if (lineY > viewportRect.y + viewportRect.w) {
                        last = mid - 1;
                    } else {
                        if (lineY <= viewportRect.y + viewportRect.w && lineY + lineHeight >= viewportRect.y) break;
                        first = mid + 1;
                    }
                    mid = (first + last) / 2;
                }
                for (first = mid - 1; first >= 0; --first) {
                    String line = lines[first];
                    float[] lineBounds = NvgRenderUtils.calculateTextBoundsRect(context, rect, line, halign, valign, fontSize);
                    bounds[first] = lineBounds;
                    float lineY = lineBounds[5] + voffset + fontSize * (float)first;
                    float lineHeight = lineBounds[7];
                    if (lineY + lineHeight <= viewportRect.y) break;
                }
                ++first;
                for (last = mid + 1; last < lineCount; ++last) {
                    String line = lines[last];
                    float[] lineBounds = NvgRenderUtils.calculateTextBoundsRect(context, rect, line, halign, valign, fontSize);
                    bounds[last] = lineBounds;
                    float lineY = lineBounds[5] + voffset + fontSize * (float)last;
                    if (lineY > viewportRect.y + viewportRect.w) break;
                }
                --last;
                int maxLength = 0;
                int longestStringIndex = 0;
                for (int i = 0; i < lines.length; ++i) {
                    String s = lines[i];
                    if (s.length() <= maxLength) continue;
                    maxLength = s.length();
                    longestStringIndex = i;
                }
                if (longestStringIndex < first || longestStringIndex > last) {
                    float[] lineBounds = NvgRenderUtils.calculateTextBoundsRect(context, rect, lines[longestStringIndex], halign, valign, fontSize);
                    maxWid = lineBounds[2];
                } else {
                    maxWid = bounds[longestStringIndex][2];
                }
            } else {
                maxWid = this.calculateLineBoundsAndMaxWidth(context, gui, rect, fontSize, halign, valign, spaceWidth, lines, lineCount, bounds, maxWid);
            }
            float textWidth = textState.getTextWidth();
            float textHeight = textState.getTextHeight();
            textState.setTextWidth(maxWid);
            float newTextHeight = (float)lines.length * fontSize;
            textState.setTextHeight(newTextHeight);
            textState.setCaretX(Float.valueOf(caretx));
            textState.setCaretY(Float.valueOf(caretLineBounds[5] + voffset + fontSize * (float)caretLine));
            if ((double)Math.abs(textWidth - maxWid) > 0.001) {
                EventProcessorProvider.getInstance().pushEvent(new TextAreaFieldWidthChangeEvent(gui, leguiContext, gui.getFrame(), maxWid));
            }
            if ((double)Math.abs(textHeight - newTextHeight) > 0.001) {
                EventProcessorProvider.getInstance().pushEvent(new TextAreaFieldHeightChangeEvent(gui, leguiContext, gui.getFrame(), newTextHeight));
            }
            if (mouseY > (llineY = bounds[lineCount - 1][5] - voffset + fontSize * (float)(lineCount - 1)) + fontSize) {
                mouseLineIndex = lineCount - 1;
            }
            if (focused) {
                ColorUtil.oppositeBlackOrWhite(bc, this.caretColor);
                this.caretColor.w = (float)Math.abs(GLFW.glfwGetTime() % 1.0 * 2.0 - 1.0);
            }
            if ((startSelectionIndex = gui.getStartSelectionIndex()) > (endSelectionIndex = gui.getEndSelectionIndex())) {
                startSelectionIndex += endSelectionIndex;
                endSelectionIndex = startSelectionIndex - endSelectionIndex;
                startSelectionIndex -= endSelectionIndex;
            }
            int startSelectionLine = 0;
            int endSelectionLine = 0;
            for (int i = 0; i < lineCount; ++i) {
                if (startSelectionIndex >= lineStartIndeces[i]) {
                    startSelectionLine = i;
                }
                if (endSelectionIndex < lineStartIndeces[i]) continue;
                endSelectionLine = i;
            }
            int startSelectionIndexInLine = startSelectionIndex - lineStartIndeces[startSelectionLine];
            int endSelectionIndexInLine = endSelectionIndex - lineStartIndeces[endSelectionLine];
            float startSelectionCaretX = this.getCaretx(context, startSelectionIndexInLine, lines[startSelectionLine], bounds[startSelectionLine], glyphs, spaceWidth, gui.getTabSize());
            float endSelectionCaretX = this.getCaretx(context, endSelectionIndexInLine, lines[endSelectionLine], bounds[endSelectionLine], glyphs, spaceWidth, gui.getTabSize());
            for (int i = first; i <= last; ++i) {
                ByteBuffer lineBytes = null;
                try {
                    String line = lines[i];
                    lineBytes = MemoryUtil.memUTF8((CharSequence)line);
                    NvgRenderUtils.alignTextInBox(context, HorizontalAlign.LEFT, VerticalAlign.MIDDLE);
                    int ng = NanoVG.nnvgTextGlyphPositions((long)context, (float)bounds[i][4], (float)0.0f, (long)MemoryUtil.memAddress((ByteBuffer)lineBytes), (long)0L, (long)MemoryUtil.memAddress((CustomBuffer)glyphs), (int)2048);
                    float lineX = bounds[i][4];
                    float lineWidth = bounds[i][6];
                    float lineY = bounds[i][5] + voffset + fontSize * (float)i;
                    float lineHeight = bounds[i][7];
                    if (this.inRect(viewportRect, lineX, lineWidth, lineY, lineHeight)) {
                        List<Integer> tabIndices = this.getTabIndices(line);
                        if (lineY <= mouseY && lineY + fontSize > mouseY) {
                            if (line.length() == 0) {
                                mouseCaretX = caretx;
                            } else if (mouseX <= ((NVGGlyphPosition)glyphs.get(0)).x()) {
                                mouseCaretPositionInLine = 0;
                                mouseCaretX = ((NVGGlyphPosition)glyphs.get(0)).x();
                            } else if (mouseX >= ((NVGGlyphPosition)glyphs.get(ng - 1)).maxx() + spaceWidth * (float)(gui.getTabSize() - 1) * (float)tabIndices.size()) {
                                mouseCaretPositionInLine = ng;
                                mouseCaretX = ((NVGGlyphPosition)glyphs.get(ng - 1)).maxx() + spaceWidth * (float)(gui.getTabSize() - 1) * (float)tabIndices.size();
                            } else if (!leguiContext.isIconified()) {
                                int upper = ng;
                                int lower = 0;
                                boolean found = false;
                                do {
                                    int index = (upper + lower) / 2;
                                    float tabAddition = 0.0f;
                                    for (Integer tabIndex : tabIndices) {
                                        if (index <= tabIndex) continue;
                                        tabAddition += spaceWidth * (float)(gui.getTabSize() - 1);
                                    }
                                    float left = ((NVGGlyphPosition)glyphs.get(index)).x();
                                    float right = index >= ng - 1 ? ((NVGGlyphPosition)glyphs.get(ng - 1)).maxx() : ((NVGGlyphPosition)glyphs.get(index + 1)).x();
                                    left += tabAddition;
                                    right += tabAddition;
                                    if (tabIndices.contains(index)) {
                                        right += spaceWidth * (float)(gui.getTabSize() - 1);
                                    }
                                    float mid = (left + right) / 2.0f;
                                    if (mouseX >= left && mouseX < right) {
                                        found = true;
                                        if (mouseX > mid) {
                                            mouseCaretPositionInLine = index + 1;
                                            mouseCaretX = right;
                                            continue;
                                        }
                                        mouseCaretPositionInLine = index;
                                        mouseCaretX = left;
                                        continue;
                                    }
                                    if (mouseX >= right) {
                                        if (index != ng) {
                                            lower = index + 1;
                                            continue;
                                        }
                                        found = true;
                                        mouseCaretPositionInLine = ng;
                                        mouseCaretX = right;
                                        continue;
                                    }
                                    if (!(mouseX < left)) continue;
                                    if (index != 0) {
                                        upper = index;
                                        continue;
                                    }
                                    found = true;
                                    mouseCaretPositionInLine = 0;
                                    mouseCaretX = left;
                                } while (!found);
                            }
                            mouseLineIndex = i;
                            if (leguiContext.isDebugEnabled()) {
                                NvgShapes.drawRectStroke(context, (Vector4fc)new Vector4f(mouseCaretX - 1.0f, lineY, 1.0f, lineHeight), (Vector4fc)new Vector4f((Vector4fc)this.caretColor).div(2.0f), 1.0f);
                            }
                        }
                        if (mouseY >= bounds[lineCount - 1][5] + voffset + fontSize * (float)(lineCount - 1) + fontSize) {
                            mouseLineIndex = lineCount - 1;
                            mouseCaretPositionInLine = lines[mouseLineIndex].length();
                        }
                        if (startSelectionIndex != endSelectionIndex && i >= startSelectionLine && i <= endSelectionLine) {
                            float x1 = bounds[i][4];
                            float w = bounds[i][6];
                            float x2 = x1 + w;
                            if (i == startSelectionLine) {
                                x1 = startSelectionCaretX;
                            }
                            if (i == endSelectionLine) {
                                x2 = endSelectionCaretX;
                            }
                            w = x2 - x1;
                            NvgShapes.drawRect(context, (Vector4fc)new Vector4f(x1, bounds[i][5] + voffset + fontSize * (float)i, w, bounds[i][7]), (Vector4fc)StyleUtilities.getStyle(gui, Style::getHighlightColor));
                        }
                        this.renderCurrentLineBackground(context, rect, bc, fontSize, focused, caretLine, i, lineY);
                        char[] spaces = new char[gui.getTabSize()];
                        Arrays.fill(spaces, ' ');
                        NvgText.drawTextLineToRect(context, (Vector4fc)new Vector4f(lineX, lineY, lineWidth, lineHeight), false, HorizontalAlign.LEFT, VerticalAlign.MIDDLE, fontSize, font, line.replace(TABS, new String(spaces)), textColor);
                        if (i == caretLine && focused) {
                            NvgShapes.drawRectStroke(context, (Vector4fc)new Vector4f(caretx - 1.0f, lineY, 1.0f, lineHeight), (Vector4fc)this.caretColor, 1.0f);
                        }
                    }
                    if (lineBytes == null) continue;
                }
                catch (Throwable throwable) {
                    if (lineBytes != null) {
                        MemoryUtil.memFree(lineBytes);
                    }
                    throw throwable;
                }
                MemoryUtil.memFree((Buffer)lineBytes);
            }
            gui.setMouseCaretPosition(lineStartIndeces[mouseLineIndex] + mouseCaretPositionInLine);
        }
    }

    private float calculateLineBoundsAndMaxWidth(long context, TextAreaField gui, Vector4f rect, float fontSize, HorizontalAlign halign, VerticalAlign valign, float spaceWidth, String[] lines, int lineCount, float[][] bounds, float maxWid) {
        for (int i = 0; i < lineCount; ++i) {
            String line = lines[i];
            float[] lineBounds = NvgRenderUtils.calculateTextBoundsRect(context, rect, line, halign, valign, fontSize);
            if (lineBounds[2] > maxWid) {
                maxWid = lineBounds[2];
            }
            bounds[i] = lineBounds;
            if (!line.contains(TABS)) continue;
            float[] fArray = bounds[i];
            fArray[6] = fArray[6] + spaceWidth * (float)(line.length() - line.replace(TABS, "").length()) * (float)(gui.getTabSize() - 1);
        }
        return maxWid;
    }

    /*
     * Loose catch block
     */
    private float getSpaceWidth(long context) {
        float f;
        NVGGlyphPosition.Buffer glyphs;
        ByteBuffer spaceBytes;
        block10: {
            block9: {
                String s = "  ";
                spaceBytes = null;
                glyphs = NVGGlyphPosition.calloc((int)2048);
                spaceBytes = MemoryUtil.memUTF8((CharSequence)s);
                NvgRenderUtils.alignTextInBox(context, HorizontalAlign.LEFT, VerticalAlign.MIDDLE);
                NanoVG.nnvgTextGlyphPositions((long)context, (float)10.0f, (float)0.0f, (long)MemoryUtil.memAddress((ByteBuffer)spaceBytes), (long)0L, (long)MemoryUtil.memAddress((CustomBuffer)glyphs), (int)2048);
                float x1 = ((NVGGlyphPosition)glyphs.get(1)).x();
                float x0 = ((NVGGlyphPosition)glyphs.get(0)).x();
                f = x1 - x0;
                if (glyphs == null) break block9;
                glyphs.close();
            }
            if (spaceBytes == null) break block10;
            MemoryUtil.memFree((Buffer)spaceBytes);
        }
        return f;
        {
            catch (Throwable throwable) {
                try {
                    if (glyphs != null) {
                        try {
                            glyphs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (spaceBytes != null) {
                        MemoryUtil.memFree(spaceBytes);
                    }
                    throw throwable3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getCaretx(long context, int caretPosInText, String text, float[] caretLineBounds, NVGGlyphPosition.Buffer glyphs, float spaceWidth, int tabSize) {
        float caretx;
        ByteBuffer caretLineBytes = null;
        try {
            caretLineBytes = MemoryUtil.memUTF8((CharSequence)text);
            NvgRenderUtils.alignTextInBox(context, HorizontalAlign.LEFT, VerticalAlign.MIDDLE);
            int ng = NanoVG.nnvgTextGlyphPositions((long)context, (float)caretLineBounds[4], (float)0.0f, (long)MemoryUtil.memAddress((ByteBuffer)caretLineBytes), (long)0L, (long)MemoryUtil.memAddress((CustomBuffer)glyphs), (int)2048);
            caretx = this.calculateCaretPos(caretPosInText, caretLineBounds, ng, glyphs);
            String substring = text.substring(0, caretPosInText);
            if (substring.contains(TABS)) {
                int tabCountBeforeCaret = substring.length() - substring.replace(TABS, "").length();
                caretx += spaceWidth * (float)tabCountBeforeCaret * (float)(tabSize - 1);
            }
        }
        finally {
            MemoryUtil.memFree((Buffer)caretLineBytes);
        }
        return caretx;
    }

    private void preinitializeTextRendering(long context, String font, float fontSize, HorizontalAlign halign, VerticalAlign valign, Vector4f textColor) {
        try (NVGColor colorA = NvgColorUtil.create((Vector4fc)textColor);){
            NvgRenderUtils.alignTextInBox(context, halign, valign);
            NanoVG.nvgFontSize((long)context, (float)fontSize);
            NanoVG.nvgFontFace((long)context, (CharSequence)font);
            NanoVG.nvgFillColor((long)context, (NVGColor)colorA);
        }
    }

    private float calculateCaretPos(int caretPosition, float[] textBounds, int ng, NVGGlyphPosition.Buffer glyphs) {
        float caretx = 0.0f;
        if (caretPosition < ng) {
            try {
                caretx = ((NVGGlyphPosition)glyphs.get(caretPosition)).x();
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        } else {
            caretx = ng > 0 ? ((NVGGlyphPosition)glyphs.get(ng - 1)).maxx() : textBounds[4];
        }
        return caretx;
    }

    private boolean inRect(Vector4f rect, float lineX, float lineWidth, float lineY, float lineHeight) {
        return rect == null || lineY <= rect.y + rect.w && lineY + lineHeight >= rect.y && lineX <= rect.x + rect.z && lineX + lineWidth >= rect.x;
    }

    private List<Integer> getTabIndices(String line) {
        ArrayList<Integer> tabIndices = new ArrayList<Integer>();
        if (line.contains(TABS)) {
            int index = line.indexOf(TABS);
            while (index != -1) {
                tabIndices.add(index);
                index = line.indexOf(TABS, index + 1);
            }
        }
        return tabIndices;
    }

    private void renderCurrentLineBackground(long context, Vector4f rect, Vector4f backgroundColor, float fontSize, boolean focused, int caretLine, int currentLineIndex, float lineY) {
        if (currentLineIndex == caretLine && focused) {
            Vector4f currentLineBgColor = ColorUtil.oppositeBlackOrWhite(backgroundColor);
            currentLineBgColor.w = 0.1f;
            NvgShapes.drawRect(context, (Vector4fc)new Vector4f(rect.x, lineY, rect.z, fontSize), (Vector4fc)currentLineBgColor);
        }
    }
}

