/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.component;

import com.spinyowl.legui.component.Slider;
import com.spinyowl.legui.component.optional.Orientation;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.component.NvgDefaultComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import com.spinyowl.legui.system.renderer.nvg.util.NvgShapes;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.nanovg.NanoVG;

public class NvgSliderRenderer
extends NvgDefaultComponentRenderer<Slider> {
    public static final float SLIDER_WIDTH = 4.0f;

    @Override
    public void renderSelf(Slider slider, Context context, long nanovg) {
        float sliderY;
        float sliderX;
        float lineEndX;
        float lineStartX;
        float lineEndY;
        float lineStartY;
        NvgRenderUtils.createScissor(nanovg, slider);
        NanoVG.nvgSave((long)nanovg);
        Vector2f pos = slider.getAbsolutePosition();
        Vector2f size = slider.getSize();
        float x = pos.x;
        float y = pos.y;
        float width = size.x;
        float height = size.y;
        Vector4f cornerRadius = NvgRenderUtils.getBorderRadius(slider);
        this.renderBackground(slider, context, nanovg);
        float minValue = slider.getMinValue();
        float maxValue = slider.getMaxValue();
        float difference = maxValue - minValue;
        float value = slider.getValue() - minValue;
        boolean vertical = Orientation.VERTICAL.equals(slider.getOrientation());
        Vector4f sliderInactiveColor = slider.getSliderColor();
        Vector4f sliderColor = slider.getSliderActiveColor();
        float sliderSize = slider.getSliderSize();
        float sliderHalfSize = sliderSize / 2.0f;
        float percentage = value / difference;
        if (vertical) {
            lineStartY = y + sliderHalfSize;
            lineEndY = y + height - sliderHalfSize;
            float sizeY = lineEndY - lineStartY;
            lineEndX = lineStartX = x + width / 2.0f;
            sliderX = lineStartX;
            sliderY = lineStartY + sizeY * percentage;
        } else {
            lineStartX = x + sliderHalfSize;
            lineEndX = x + width - sliderHalfSize;
            float sizeX = lineEndX - lineStartX;
            lineEndY = lineStartY = y + height / 2.0f;
            sliderY = lineStartY;
            sliderX = lineStartX + sizeX * percentage;
        }
        NvgShapes.drawLine(nanovg, 4.0f, sliderInactiveColor, 1, lineStartX, lineStartY, lineEndX, lineEndY);
        Vector2f sliderButtonSize = new Vector2f(sliderSize);
        Vector2f sliderPos = new Vector2f(sliderX - sliderHalfSize, sliderY - sliderHalfSize);
        NvgShapes.drawRect(nanovg, (Vector2fc)sliderPos, (Vector2fc)sliderButtonSize, (Vector4fc)sliderColor, cornerRadius);
        NvgShapes.drawRectStroke(nanovg, (Vector2fc)sliderPos, (Vector2fc)sliderButtonSize, (Vector4fc)sliderInactiveColor, 1.0f, cornerRadius);
        NvgRenderUtils.resetScissor(nanovg);
    }
}

