/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.component;

import com.spinyowl.legui.component.RadioButton;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.font.FontRegistry;
import com.spinyowl.legui.style.util.StyleUtilities;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.NvgRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgDefaultComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import com.spinyowl.legui.system.renderer.nvg.util.NvgText;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class NvgRadioButtonRenderer
extends NvgDefaultComponentRenderer<RadioButton> {
    @Override
    public void renderSelf(RadioButton radioButton, Context context, long nanovg) {
        NvgRenderUtils.createScissor(nanovg, radioButton);
        Style style = radioButton.getStyle();
        Vector2f pos = radioButton.getAbsolutePosition();
        Vector2f size = radioButton.getSize();
        this.renderBackground(radioButton, context, nanovg);
        TextState textState = radioButton.getTextState();
        Icon icon = radioButton.isChecked() ? radioButton.getIconChecked() : radioButton.getIconUnchecked();
        Vector4f padding = StyleUtilities.getPadding(radioButton, style);
        Vector4f pad = new Vector4f(padding.w, padding.x, padding.y, padding.z);
        float iconWidthForUse = (float)(icon.getHorizontalAlign().index == 0 ? 1 : 0) * icon.getSize().x;
        Vector2f textRectPos = new Vector2f(pos.x + iconWidthForUse, pos.y + pad.y);
        Vector2f textRectSize = new Vector2f(size.x - iconWidthForUse - pad.z, size.y - (pad.y + pad.w));
        Vector4f rect = new Vector4f((Vector2fc)textRectPos, textRectSize.x(), textRectSize.y());
        NvgText.drawTextLineToRect(nanovg, (Vector4fc)rect, true, StyleUtilities.getStyle(radioButton, Style::getHorizontalAlign, HorizontalAlign.LEFT), StyleUtilities.getStyle(radioButton, Style::getVerticalAlign, VerticalAlign.MIDDLE), StyleUtilities.getStyle(radioButton, Style::getFontSize, Float.valueOf(16.0f)).floatValue(), StyleUtilities.getStyle(radioButton, Style::getFont, FontRegistry.getDefaultFont()), textState.getText(), StyleUtilities.getStyle(radioButton, Style::getTextColor));
        NvgRenderer.renderIcon(icon, radioButton, context);
        NvgRenderUtils.resetScissor(nanovg);
    }
}

