/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.component;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.style.util.StyleUtilities;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.RendererProvider;
import com.spinyowl.legui.system.renderer.nvg.NvgComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.NvgRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import com.spinyowl.legui.system.renderer.nvg.util.NvgShapes;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.nanovg.NanoVG;

public class NvgDefaultComponentRenderer<C extends Component>
extends NvgComponentRenderer<C> {
    @Override
    protected void renderComponent(C component, Context context, long nanovg) {
        if (((Component)component).isVisible() && (double)((Component)component).getSize().lengthSquared() > 0.01) {
            this.renderSelf(component, context, nanovg);
            this.renderChildComponents(component, context, nanovg);
            this.renderBorder(component, context, nanovg);
        }
    }

    protected void renderSelf(C component, Context context, long nanovg) {
        NvgRenderUtils.createScissor(nanovg, component);
        this.renderBackground(component, context, nanovg);
        NvgRenderUtils.resetScissor(nanovg);
    }

    protected void renderBackground(C component, Context context, long nanovg) {
        Icon bgIcon = StyleUtilities.getStyle(component, s -> s.getBackground().getIcon());
        Vector4f bgColor = StyleUtilities.getStyle(component, s -> s.getBackground().getColor());
        Vector4f cornerRadius = NvgRenderUtils.getBorderRadius(component);
        NvgRenderUtils.renderShadow(nanovg, component);
        NanoVG.nvgSave((long)nanovg);
        NvgShapes.drawRect(nanovg, (Vector2fc)((Component)component).getAbsolutePosition(), (Vector2fc)((Component)component).getSize(), (Vector4fc)bgColor, cornerRadius);
        if (bgIcon != null) {
            NvgRenderer.renderIcon(bgIcon, component, context);
        }
        NanoVG.nvgRestore((long)nanovg);
    }

    protected void renderChildComponents(C component, Context context, long nanovg) {
        for (Component child : ((Component)component).getChildComponents()) {
            RendererProvider.getInstance().getComponentRenderer(child.getClass()).render(child, context);
        }
    }

    protected void renderBorder(C component, Context context, long nanovg) {
        NvgRenderer.renderBorderWScissor(component, context, nanovg);
    }
}

