/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.component;

import com.spinyowl.legui.component.CheckBox;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.font.FontRegistry;
import com.spinyowl.legui.style.util.StyleUtilities;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.NvgRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgDefaultComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import com.spinyowl.legui.system.renderer.nvg.util.NvgText;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class NvgCheckBoxRenderer
extends NvgDefaultComponentRenderer<CheckBox> {
    @Override
    public void renderSelf(CheckBox checkBox, Context context, long nanovg) {
        NvgRenderUtils.createScissor(nanovg, checkBox);
        Style style = checkBox.getStyle();
        Vector2f pos = checkBox.getAbsolutePosition();
        Vector2f size = checkBox.getSize();
        this.renderBackground(checkBox, context, nanovg);
        TextState textState = checkBox.getTextState();
        Icon icon = checkBox.isChecked() ? checkBox.getIconChecked() : checkBox.getIconUnchecked();
        float iconWid = icon.getSize().x;
        Vector4f padding = StyleUtilities.getPadding(checkBox, style);
        float iconWidthForUse = (float)(icon.getHorizontalAlign().index == 0 ? 1 : 0) * iconWid;
        float h = size.y - (padding.y + padding.w);
        float y = pos.y + padding.y;
        float x = pos.x + iconWidthForUse + padding.x;
        float w = size.x - iconWidthForUse - padding.z - padding.x;
        Vector2f size1 = new Vector2f(w, h);
        Vector4f rect = new Vector4f((Vector2fc)new Vector2f(x, y), size1.x(), size1.y());
        NvgText.drawTextLineToRect(nanovg, (Vector4fc)rect, true, StyleUtilities.getStyle(checkBox, Style::getHorizontalAlign, HorizontalAlign.LEFT), StyleUtilities.getStyle(checkBox, Style::getVerticalAlign, VerticalAlign.MIDDLE), StyleUtilities.getStyle(checkBox, Style::getFontSize, Float.valueOf(16.0f)).floatValue(), StyleUtilities.getStyle(checkBox, Style::getFont, FontRegistry.getDefaultFont()), textState.getText(), StyleUtilities.getStyle(checkBox, Style::getTextColor));
        NvgRenderer.renderIcon(icon, checkBox, context);
        NvgRenderUtils.resetScissor(nanovg);
    }
}

