/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.border;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.border.SimpleLineBorder;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.NvgBorderRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import com.spinyowl.legui.system.renderer.nvg.util.NvgShapes;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class NvgSimpleLineBorderRenderer
extends NvgBorderRenderer<SimpleLineBorder> {
    @Override
    protected void renderBorder(SimpleLineBorder border, Component component, Context context, long nanovg) {
        if (border.isEnabled()) {
            float thickness = border.getThickness();
            Vector4f borderColor = border.getColor();
            if (thickness <= 0.0f || borderColor.w == 0.0f) {
                return;
            }
            Vector2f size = component.getSize();
            Style style = component.getStyle();
            Vector2f absolutePosition = component.getAbsolutePosition();
            Vector2f bSize = new Vector2f((Vector2fc)size);
            bSize.add(thickness, thickness);
            Vector2f bPos = new Vector2f((Vector2fc)absolutePosition).sub(thickness / 2.0f, thickness / 2.0f);
            Vector4f borderRadius = NvgRenderUtils.getBorderRadius(component);
            if (component.isFocused() && style.getFocusedStrokeColor() != null) {
                Vector4f strokeColor = style.getFocusedStrokeColor();
                NvgShapes.drawRectStroke(nanovg, (Vector2fc)new Vector2f((Vector2fc)bPos).add(-0.5f, 0.5f), (Vector2fc)new Vector2f((Vector2fc)bSize).add(1.0f, 1.0f), (Vector4fc)strokeColor, 1.0f, borderRadius);
            }
            NvgShapes.drawRectStroke(nanovg, (Vector2fc)bPos, (Vector2fc)bSize, (Vector4fc)borderColor, thickness, borderRadius);
        }
    }
}

