/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg;

import com.spinyowl.legui.component.Button;
import com.spinyowl.legui.component.CheckBox;
import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.ImageView;
import com.spinyowl.legui.component.Label;
import com.spinyowl.legui.component.PasswordInput;
import com.spinyowl.legui.component.ProgressBar;
import com.spinyowl.legui.component.RadioButton;
import com.spinyowl.legui.component.ScrollBar;
import com.spinyowl.legui.component.Slider;
import com.spinyowl.legui.component.TextAreaField;
import com.spinyowl.legui.component.TextInput;
import com.spinyowl.legui.component.ToggleButton;
import com.spinyowl.legui.component.Tooltip;
import com.spinyowl.legui.icon.CharIcon;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.icon.ImageIcon;
import com.spinyowl.legui.image.BufferedImageRGBA;
import com.spinyowl.legui.image.FBOImage;
import com.spinyowl.legui.image.Image;
import com.spinyowl.legui.image.StbBackedLoadableImage;
import com.spinyowl.legui.style.Border;
import com.spinyowl.legui.style.border.SimpleLineBorder;
import com.spinyowl.legui.system.renderer.BorderRenderer;
import com.spinyowl.legui.system.renderer.ComponentRenderer;
import com.spinyowl.legui.system.renderer.IconRenderer;
import com.spinyowl.legui.system.renderer.ImageRenderer;
import com.spinyowl.legui.system.renderer.RendererProvider;
import com.spinyowl.legui.system.renderer.nvg.NvgBorderRenderer;
import com.spinyowl.legui.system.renderer.nvg.NvgComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.NvgIconRenderer;
import com.spinyowl.legui.system.renderer.nvg.NvgImageRenderer;
import com.spinyowl.legui.system.renderer.nvg.border.NvgDefaultBorderRenderer;
import com.spinyowl.legui.system.renderer.nvg.border.NvgSimpleLineBorderRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgButtonRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgCheckBoxRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgDefaultComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgImageViewRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgLabelRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgPasswordInputRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgProgressBarRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgRadioButtonRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgScrollBarRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgSliderRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgTextAreaFieldRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgTextInputRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgToggleButtonRenderer;
import com.spinyowl.legui.system.renderer.nvg.component.NvgTooltipRenderer;
import com.spinyowl.legui.system.renderer.nvg.icon.NvgCharIconRenderer;
import com.spinyowl.legui.system.renderer.nvg.icon.NvgDefaultIconRenderer;
import com.spinyowl.legui.system.renderer.nvg.icon.NvgImageIconRenderer;
import com.spinyowl.legui.system.renderer.nvg.image.NvgBufferedImageRGBARenderer;
import com.spinyowl.legui.system.renderer.nvg.image.NvgDefaultImageRenderer;
import com.spinyowl.legui.system.renderer.nvg.image.NvgFBOImageRenderer;
import com.spinyowl.legui.system.renderer.nvg.image.NvgStbBackedLoadableImageRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NvgRendererProvider
implements RendererProvider {
    private final Map<Class<? extends Component>, ComponentRenderer<? extends Component>> componentRendererMap = new ConcurrentHashMap<Class<? extends Component>, ComponentRenderer<? extends Component>>();
    private final Map<Class<? extends Border>, BorderRenderer<? extends Border>> borderRendererMap = new ConcurrentHashMap<Class<? extends Border>, BorderRenderer<? extends Border>>();
    private final Map<Class<? extends Icon>, IconRenderer<? extends Icon>> iconRendererMap = new ConcurrentHashMap<Class<? extends Icon>, IconRenderer<? extends Icon>>();
    private final Map<Class<? extends Image>, ImageRenderer<? extends Image>> imageRendererMap = new ConcurrentHashMap<Class<? extends Image>, ImageRenderer<? extends Image>>();
    private final NvgComponentRenderer defaultComponentRenderer = new NvgDefaultComponentRenderer();
    private final NvgBorderRenderer defaultBorderRenderer = new NvgDefaultBorderRenderer();
    private final NvgIconRenderer defaultIconRenderer = new NvgDefaultIconRenderer();
    private final NvgImageRenderer defaultImageRenderer = new NvgDefaultImageRenderer();

    private NvgRendererProvider() {
        this.componentRendererMap.put(Button.class, new NvgButtonRenderer());
        this.componentRendererMap.put(ToggleButton.class, new NvgToggleButtonRenderer());
        this.componentRendererMap.put(ImageView.class, new NvgImageViewRenderer());
        this.componentRendererMap.put(CheckBox.class, new NvgCheckBoxRenderer());
        this.componentRendererMap.put(Label.class, new NvgLabelRenderer());
        this.componentRendererMap.put(ProgressBar.class, new NvgProgressBarRenderer());
        this.componentRendererMap.put(RadioButton.class, new NvgRadioButtonRenderer());
        this.componentRendererMap.put(ScrollBar.class, new NvgScrollBarRenderer());
        this.componentRendererMap.put(Slider.class, new NvgSliderRenderer());
        this.componentRendererMap.put(TextAreaField.class, new NvgTextAreaFieldRenderer());
        this.componentRendererMap.put(TextInput.class, new NvgTextInputRenderer());
        this.componentRendererMap.put(PasswordInput.class, new NvgPasswordInputRenderer());
        this.componentRendererMap.put(Tooltip.class, new NvgTooltipRenderer());
        this.borderRendererMap.put(SimpleLineBorder.class, new NvgSimpleLineBorderRenderer());
        this.iconRendererMap.put(ImageIcon.class, new NvgImageIconRenderer());
        this.iconRendererMap.put(CharIcon.class, new NvgCharIconRenderer());
        this.imageRendererMap.put(StbBackedLoadableImage.class, new NvgStbBackedLoadableImageRenderer());
        this.imageRendererMap.put(FBOImage.class, new NvgFBOImageRenderer());
        this.imageRendererMap.put(BufferedImageRGBA.class, new NvgBufferedImageRGBARenderer());
    }

    public static NvgRendererProvider getInstance() {
        return NRPH.I;
    }

    @Override
    public <C extends Component> ComponentRenderer<C> getComponentRenderer(Class<C> componentClass) {
        return this.cycledSearchOfRenderer(componentClass, this.componentRendererMap, this.defaultComponentRenderer);
    }

    public <B extends Border> BorderRenderer<B> getBorderRenderer(Class<B> borderClass) {
        return this.cycledSearchOfRenderer(borderClass, this.borderRendererMap, this.defaultBorderRenderer);
    }

    public <C extends Icon> IconRenderer getIconRenderer(Class<C> iconClass) {
        return this.cycledSearchOfRenderer(iconClass, this.iconRendererMap, this.defaultIconRenderer);
    }

    @Override
    public <I extends Image> ImageRenderer getImageRenderer(Class<I> imageClass) {
        return this.cycledSearchOfRenderer(imageClass, this.imageRendererMap, this.defaultImageRenderer);
    }

    private <C, R> R cycledSearchOfRenderer(Class<C> componentClass, Map map, R defaultRenderer) {
        R renderer = null;
        Class<C> cClass = componentClass;
        while (renderer == null) {
            renderer = (R)map.get(cClass);
            if (cClass.isAssignableFrom(Component.class)) break;
            cClass = cClass.getSuperclass();
        }
        if (renderer == null) {
            renderer = defaultRenderer;
        }
        return renderer;
    }

    public <I extends Component, R extends NvgComponentRenderer<I>> void putComponentRenderer(Class<I> imageClass, R renderer) {
        this.addComponentRenderer(imageClass, renderer);
    }

    public <I extends Component, R extends ComponentRenderer<I>> void addComponentRenderer(Class<I> imageClass, R renderer) {
        if (imageClass == null || renderer == null) {
            return;
        }
        this.componentRendererMap.put(imageClass, renderer);
    }

    public <I extends Border, R extends BorderRenderer<I>> void addBorderRenderer(Class<I> imageClass, R renderer) {
        if (imageClass == null || renderer == null) {
            return;
        }
        this.borderRendererMap.put(imageClass, renderer);
    }

    @Override
    public <I extends Icon, R extends IconRenderer<I>> void addIconRenderer(Class<I> imageClass, R renderer) {
        if (imageClass == null || renderer == null) {
            return;
        }
        this.iconRendererMap.put(imageClass, renderer);
    }

    @Override
    public <I extends Image, R extends ImageRenderer<I>> void addImageRenderer(Class<I> imageClass, R renderer) {
        if (imageClass == null || renderer == null) {
            return;
        }
        this.imageRendererMap.put(imageClass, renderer);
    }

    @Override
    public List<ComponentRenderer> getComponentRenderers() {
        return new ArrayList<ComponentRenderer>(this.componentRendererMap.values());
    }

    private static final class NRPH {
        private static final NvgRendererProvider I = new NvgRendererProvider();

        private NRPH() {
        }
    }
}

