/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.image.Image;
import com.spinyowl.legui.style.Border;
import com.spinyowl.legui.style.font.Font;
import com.spinyowl.legui.style.font.FontRegistry;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.AbstractRenderer;
import com.spinyowl.legui.system.renderer.BorderRenderer;
import com.spinyowl.legui.system.renderer.ComponentRenderer;
import com.spinyowl.legui.system.renderer.RendererProvider;
import com.spinyowl.legui.system.renderer.nvg.NvgImageReferenceManager;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.nanovg.NanoVGGL2;
import org.lwjgl.nanovg.NanoVGGL3;
import org.lwjgl.opengl.GL11;

public class NvgRenderer
extends AbstractRenderer {
    public static final String NVG_CONTEXT = "NVG_CONTEXT";
    public static final String IMAGE_REFERENCE_MANAGER = "IMAGE_REFERENCE_MANAGER";
    private final NvgImageReferenceManager imageReferenceManager = NvgImageReferenceManager.getInstance();
    private final boolean antialiasingEnabled;
    protected Map<String, Font> loadedFonts = new ConcurrentHashMap<String, Font>();
    private long nvgContext;
    private boolean isVersionNew;

    public NvgRenderer(boolean antialiasingEnabled) {
        this.antialiasingEnabled = antialiasingEnabled;
    }

    public NvgRenderer() {
        this(true);
    }

    public static void renderBorder(Component component, Context context) {
        Border border = component.getStyle().getBorder();
        if (border != null && border.isEnabled()) {
            BorderRenderer borderRenderer = RendererProvider.getInstance().getBorderRenderer(border.getClass());
            borderRenderer.render(border, component, context);
        }
    }

    public static void renderBorderWScissor(Component component, Context context, long nanovg) {
        NvgRenderUtils.createScissor(nanovg, component);
        NvgRenderer.renderBorder(component, context);
        NvgRenderUtils.resetScissor(nanovg);
    }

    public static void renderIcon(Icon icon, Component component, Context context) {
        if (icon != null && component != null) {
            RendererProvider.getInstance().getIconRenderer(icon.getClass()).render(icon, component, context);
        }
    }

    public static void renderImage(Image image, Vector2fc position, Vector2fc size, Map<String, Object> properties, Context context) {
        if (image != null) {
            RendererProvider.getInstance().getImageRenderer(image.getClass()).render(image, position, size, properties, context);
        }
    }

    @Override
    public void initialize() {
        boolean bl = this.isVersionNew = GL11.glGetInteger((int)33307) > 3 || GL11.glGetInteger((int)33307) == 3 && GL11.glGetInteger((int)33308) >= 2;
        if (this.isVersionNew) {
            int flags = this.antialiasingEnabled ? 3 : 2;
            this.nvgContext = NanoVGGL3.nvgCreate((int)flags);
        } else {
            int flags = this.antialiasingEnabled ? 3 : 2;
            this.nvgContext = NanoVGGL2.nvgCreate((int)flags);
        }
        RendererProvider.getInstance().getComponentRenderers().forEach(ComponentRenderer::initialize);
    }

    private void loadFontsToNvg() {
        Map<String, Font> fontRegister = FontRegistry.getFontRegister();
        for (Map.Entry<String, Font> fontDataEntry : fontRegister.entrySet()) {
            String fontName = fontDataEntry.getKey();
            Font font = fontDataEntry.getValue();
            if (this.loadedFonts.get(fontName) != null && this.loadedFonts.get(fontName).equals(font)) continue;
            NanoVG.nvgCreateFontMem((long)this.nvgContext, (CharSequence)fontName, (ByteBuffer)fontDataEntry.getValue().getData(), (int)0);
            this.loadedFonts.put(fontName, font);
        }
    }

    @Override
    protected void preRender(Context context) {
        this.loadFontsToNvg();
        context.getContextData().put(NVG_CONTEXT, this.nvgContext);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vector2i windowSize = context.getWindowSize();
        NanoVG.nvgBeginFrame((long)this.nvgContext, (float)windowSize.x, (float)windowSize.y, (float)context.getPixelRatio());
    }

    @Override
    protected void postRender(Context context) {
        NanoVG.nvgEndFrame((long)this.nvgContext);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        this.imageReferenceManager.removeOldImages(this.nvgContext);
        context.getContextData().remove(NVG_CONTEXT);
        context.getContextData().remove(IMAGE_REFERENCE_MANAGER);
    }

    @Override
    public void destroy() {
        if (this.isVersionNew) {
            NanoVGGL3.nnvgDelete((long)this.nvgContext);
        } else {
            NanoVGGL2.nnvgDelete((long)this.nvgContext);
        }
        RendererProvider.getInstance().getComponentRenderers().forEach(ComponentRenderer::destroy);
        this.imageReferenceManager.destroy();
    }
}

