/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg;

import com.spinyowl.legui.image.Image;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.ImageRenderer;
import java.util.Map;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.lwjgl.nanovg.NVGPaint;
import org.lwjgl.nanovg.NanoVG;

public abstract class NvgImageRenderer<I extends Image>
extends ImageRenderer<I> {
    @Override
    public void renderImage(I image, Vector2fc position, Vector2fc size, Map<String, Object> properties, Context context) {
        if (image == null) {
            return;
        }
        long nanovgContext = (Long)context.getContextData().get("NVG_CONTEXT");
        this.renderImage(image, position, size, properties, context, nanovgContext);
    }

    protected abstract void renderImage(I var1, Vector2fc var2, Vector2fc var3, Map<String, Object> var4, Context var5, long var6);

    protected void renderImage(int imageRef, Vector2fc position, Vector2fc size, Map<String, Object> properties, long nanovg) {
        try (NVGPaint imagePaint = NVGPaint.calloc();){
            float x = position.x();
            float y = position.y();
            float w = size.x();
            float h = size.y();
            Vector4f r = (Vector4f)properties.getOrDefault("C_RADIUS", 0);
            NanoVG.nvgBeginPath((long)nanovg);
            NanoVG.nvgImagePattern((long)nanovg, (float)x, (float)y, (float)w, (float)h, (float)0.0f, (int)imageRef, (float)1.0f, (NVGPaint)imagePaint);
            NanoVG.nvgRoundedRectVarying((long)nanovg, (float)x, (float)y, (float)w, (float)h, (float)r.x, (float)r.y, (float)r.z, (float)r.w);
            NanoVG.nvgFillPaint((long)nanovg, (NVGPaint)imagePaint);
            NanoVG.nvgFill((long)nanovg);
        }
    }
}

