/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.layout;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.component.Layer;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.layout.Layout;
import com.spinyowl.legui.system.layout.LayoutManager;
import com.spinyowl.legui.system.layout.flex.FlexLayout;
import com.spinyowl.legui.util.Utilites;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultLayoutManager
extends LayoutManager {
    private Map<Style.DisplayType, Layout> layoutMap = new ConcurrentHashMap<Style.DisplayType, Layout>();

    public DefaultLayoutManager() {
        this.registerLayout(Style.DisplayType.FLEX, new FlexLayout());
    }

    @Override
    public void layout(Frame frame, Context context) {
        for (Layer layer : frame.getAllLayers()) {
            this.layout(layer, frame, context);
        }
    }

    @Override
    public void registerLayout(Style.DisplayType displayType, Layout layout) {
        if (displayType == null) {
            return;
        }
        if (layout == null) {
            this.layoutMap.remove((Object)displayType);
        } else {
            this.layoutMap.put(displayType, layout);
        }
    }

    @Override
    public void layout(Component component, Frame frame, Context context) {
        if (component != null && component.isVisible() && Utilites.visibleInParents(component)) {
            Layout layout = this.layoutMap.get((Object)component.getStyle().getDisplay());
            if (layout != null) {
                layout.layout(component, frame, context);
            }
            if (!component.isEmpty()) {
                List<Component> childComponents = component.getChildComponents();
                for (Component child : childComponents) {
                    this.layout(child, frame, context);
                }
            }
        }
    }
}

