/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.handler.processor;

import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.event.SystemEvent;
import com.spinyowl.legui.system.handler.SystemEventHandler;
import com.spinyowl.legui.system.handler.SystemEventHandlerProvider;
import com.spinyowl.legui.system.handler.processor.SystemEventProcessor;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SystemEventProcessorImpl
implements SystemEventProcessor {
    private Queue<SystemEvent> first = new ConcurrentLinkedQueue<SystemEvent>();
    private Queue<SystemEvent> second = new ConcurrentLinkedQueue<SystemEvent>();

    @Override
    public void processEvents(Frame frame, Context context) {
        this.swap();
        SystemEvent event = this.second.poll();
        while (event != null) {
            SystemEventHandler<?> processor = SystemEventHandlerProvider.getInstance().getProcessor(event.getClass());
            if (processor != null) {
                processor.handle(event, frame, context);
            }
            event = this.second.poll();
        }
    }

    private void swap() {
        Queue<SystemEvent> temp = this.first;
        this.first = this.second;
        this.second = temp;
    }

    @Override
    public void pushEvent(SystemEvent event) {
        this.first.add(event);
    }

    @Override
    public boolean hasEvents() {
        return !this.first.isEmpty() || !this.second.isEmpty();
    }
}

