/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.handler.processor;

import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.system.context.CallbackKeeper;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.event.SystemCharEvent;
import com.spinyowl.legui.system.event.SystemCharModsEvent;
import com.spinyowl.legui.system.event.SystemCursorEnterEvent;
import com.spinyowl.legui.system.event.SystemCursorPosEvent;
import com.spinyowl.legui.system.event.SystemDropEvent;
import com.spinyowl.legui.system.event.SystemEvent;
import com.spinyowl.legui.system.event.SystemFramebufferSizeEvent;
import com.spinyowl.legui.system.event.SystemKeyEvent;
import com.spinyowl.legui.system.event.SystemMouseClickEvent;
import com.spinyowl.legui.system.event.SystemScrollEvent;
import com.spinyowl.legui.system.event.SystemWindowCloseEvent;
import com.spinyowl.legui.system.event.SystemWindowFocusEvent;
import com.spinyowl.legui.system.event.SystemWindowIconifyEvent;
import com.spinyowl.legui.system.event.SystemWindowPosEvent;
import com.spinyowl.legui.system.event.SystemWindowRefreshEvent;
import com.spinyowl.legui.system.event.SystemWindowSizeEvent;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCharModsCallbackI;
import org.lwjgl.glfw.GLFWCursorEnterCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWWindowCloseCallbackI;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.glfw.GLFWWindowRefreshCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.system.CallbackI;

public interface SystemEventProcessor {
    public static void addDefaultCallbacks(CallbackKeeper guiCallbackKeeper, SystemEventProcessor processor) {
        guiCallbackKeeper.getChainCharCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwCharCallbackI(processor));
        guiCallbackKeeper.getChainDropCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwDropCallbackI(processor));
        guiCallbackKeeper.getChainKeyCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwKeyCallbackI(processor));
        guiCallbackKeeper.getChainScrollCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwScrollCallbackI(processor));
        guiCallbackKeeper.getChainCharModsCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwCharModsCallbackI(processor));
        guiCallbackKeeper.getChainCursorEnterCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwCursorEnterCallbackI(processor));
        guiCallbackKeeper.getChainFramebufferSizeCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwFramebufferSizeCallbackI(processor));
        guiCallbackKeeper.getChainMouseButtonCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwMouseButtonCallbackI(processor));
        guiCallbackKeeper.getChainCursorPosCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwCursorPosCallbackI(processor));
        guiCallbackKeeper.getChainWindowCloseCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwWindowCloseCallbackI(processor));
        guiCallbackKeeper.getChainWindowFocusCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwWindowFocusCallbackI(processor));
        guiCallbackKeeper.getChainWindowIconifyCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwWindowIconifyCallbackI(processor));
        guiCallbackKeeper.getChainWindowPosCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwWindowPosCallbackI(processor));
        guiCallbackKeeper.getChainWindowRefreshCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwWindowRefreshCallbackI(processor));
        guiCallbackKeeper.getChainWindowSizeCallback().add((CallbackI)SystemEventProcessor.createDefaultGlfwWindowSizeCallbackI(processor));
    }

    public static GLFWWindowSizeCallbackI createDefaultGlfwWindowSizeCallbackI(SystemEventProcessor processor) {
        return (window, width, height) -> processor.pushEvent(new SystemWindowSizeEvent(window, width, height));
    }

    public static GLFWWindowRefreshCallbackI createDefaultGlfwWindowRefreshCallbackI(SystemEventProcessor processor) {
        return window -> processor.pushEvent(new SystemWindowRefreshEvent(window));
    }

    public static GLFWWindowPosCallbackI createDefaultGlfwWindowPosCallbackI(SystemEventProcessor processor) {
        return (window, xpos, ypos) -> processor.pushEvent(new SystemWindowPosEvent(window, xpos, ypos));
    }

    public static GLFWWindowIconifyCallbackI createDefaultGlfwWindowIconifyCallbackI(SystemEventProcessor processor) {
        return (window, iconified) -> processor.pushEvent(new SystemWindowIconifyEvent(window, iconified));
    }

    public static GLFWWindowFocusCallbackI createDefaultGlfwWindowFocusCallbackI(SystemEventProcessor processor) {
        return (window, focused) -> processor.pushEvent(new SystemWindowFocusEvent(window, focused));
    }

    public static GLFWWindowCloseCallbackI createDefaultGlfwWindowCloseCallbackI(SystemEventProcessor processor) {
        return window -> processor.pushEvent(new SystemWindowCloseEvent(window));
    }

    public static GLFWCursorPosCallbackI createDefaultGlfwCursorPosCallbackI(SystemEventProcessor processor) {
        return (window, xpos, ypos) -> processor.pushEvent(new SystemCursorPosEvent(window, xpos, ypos));
    }

    public static GLFWMouseButtonCallbackI createDefaultGlfwMouseButtonCallbackI(SystemEventProcessor processor) {
        return (window, button, action, mods) -> processor.pushEvent(new SystemMouseClickEvent(window, button, action, mods));
    }

    public static GLFWFramebufferSizeCallbackI createDefaultGlfwFramebufferSizeCallbackI(SystemEventProcessor processor) {
        return (window, width, height) -> processor.pushEvent(new SystemFramebufferSizeEvent(window, width, height));
    }

    public static GLFWCursorEnterCallbackI createDefaultGlfwCursorEnterCallbackI(SystemEventProcessor processor) {
        return (window, entered) -> processor.pushEvent(new SystemCursorEnterEvent(window, entered));
    }

    public static GLFWCharModsCallbackI createDefaultGlfwCharModsCallbackI(SystemEventProcessor processor) {
        return (window, codepoint, mods) -> processor.pushEvent(new SystemCharModsEvent(window, codepoint, mods));
    }

    public static GLFWScrollCallbackI createDefaultGlfwScrollCallbackI(SystemEventProcessor processor) {
        return (window, xoffset, yoffset) -> processor.pushEvent(new SystemScrollEvent(window, xoffset, yoffset));
    }

    public static GLFWKeyCallbackI createDefaultGlfwKeyCallbackI(SystemEventProcessor processor) {
        return (window, key, scancode, action, mods) -> processor.pushEvent(new SystemKeyEvent(window, key, scancode, action, mods));
    }

    public static GLFWDropCallbackI createDefaultGlfwDropCallbackI(SystemEventProcessor processor) {
        return (window, count, names) -> processor.pushEvent(new SystemDropEvent(window, count, names));
    }

    public static GLFWCharCallbackI createDefaultGlfwCharCallbackI(SystemEventProcessor processor) {
        return (window, codepoint) -> processor.pushEvent(new SystemCharEvent(window, codepoint));
    }

    public void processEvents(Frame var1, Context var2);

    public void pushEvent(SystemEvent var1);

    public boolean hasEvents();
}

