/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.handler;

import com.spinyowl.legui.system.event.SystemCharEvent;
import com.spinyowl.legui.system.event.SystemCursorPosEvent;
import com.spinyowl.legui.system.event.SystemDropEvent;
import com.spinyowl.legui.system.event.SystemEvent;
import com.spinyowl.legui.system.event.SystemKeyEvent;
import com.spinyowl.legui.system.event.SystemMouseClickEvent;
import com.spinyowl.legui.system.event.SystemScrollEvent;
import com.spinyowl.legui.system.event.SystemWindowCloseEvent;
import com.spinyowl.legui.system.event.SystemWindowFocusEvent;
import com.spinyowl.legui.system.event.SystemWindowIconifyEvent;
import com.spinyowl.legui.system.event.SystemWindowPosEvent;
import com.spinyowl.legui.system.event.SystemWindowRefreshEvent;
import com.spinyowl.legui.system.event.SystemWindowSizeEvent;
import com.spinyowl.legui.system.handler.CharEventHandler;
import com.spinyowl.legui.system.handler.CursorPosEventHandler;
import com.spinyowl.legui.system.handler.DropEventHandler;
import com.spinyowl.legui.system.handler.KeyEventHandler;
import com.spinyowl.legui.system.handler.MouseClickEventHandler;
import com.spinyowl.legui.system.handler.ScrollEventHandler;
import com.spinyowl.legui.system.handler.SystemEventHandler;
import com.spinyowl.legui.system.handler.WindowCloseEventHandler;
import com.spinyowl.legui.system.handler.WindowFocusEventHandler;
import com.spinyowl.legui.system.handler.WindowIconifyEventHandler;
import com.spinyowl.legui.system.handler.WindowPosEventHandler;
import com.spinyowl.legui.system.handler.WindowRefreshEventHandler;
import com.spinyowl.legui.system.handler.WindowSizeEventHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SystemEventHandlerProvider {
    private Map<Class<? extends SystemEvent>, SystemEventHandler<? extends SystemEvent>> processorMap = new ConcurrentHashMap<Class<? extends SystemEvent>, SystemEventHandler<? extends SystemEvent>>();

    private SystemEventHandlerProvider() {
        this.registerProcessor(SystemWindowCloseEvent.class, new WindowCloseEventHandler());
        this.registerProcessor(SystemWindowIconifyEvent.class, new WindowIconifyEventHandler());
        this.registerProcessor(SystemScrollEvent.class, new ScrollEventHandler());
        this.registerProcessor(SystemWindowFocusEvent.class, new WindowFocusEventHandler());
        this.registerProcessor(SystemWindowPosEvent.class, new WindowPosEventHandler());
        this.registerProcessor(SystemWindowRefreshEvent.class, new WindowRefreshEventHandler());
        this.registerProcessor(SystemWindowSizeEvent.class, new WindowSizeEventHandler());
        this.registerProcessor(SystemCursorPosEvent.class, new CursorPosEventHandler());
        this.registerProcessor(SystemMouseClickEvent.class, new MouseClickEventHandler());
        this.registerProcessor(SystemKeyEvent.class, new KeyEventHandler());
        this.registerProcessor(SystemCharEvent.class, new CharEventHandler());
        this.registerProcessor(SystemDropEvent.class, new DropEventHandler());
    }

    public static SystemEventHandlerProvider getInstance() {
        return LSEPPH.I;
    }

    public <E extends SystemEvent> void registerProcessor(Class<E> eventClass, SystemEventHandler<E> processor) {
        this.processorMap.put(eventClass, processor);
    }

    public <E extends SystemEvent> SystemEventHandler<E> getProcessor(Class<E> eventClass) {
        return this.processorMap.get(eventClass);
    }

    private static class LSEPPH {
        private static final SystemEventHandlerProvider I = new SystemEventHandlerProvider();

        private LSEPPH() {
        }
    }
}

