/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.handler;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.component.Layer;
import com.spinyowl.legui.event.CursorEnterEvent;
import com.spinyowl.legui.event.MouseDragEvent;
import com.spinyowl.legui.input.Mouse;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.event.SystemCursorPosEvent;
import com.spinyowl.legui.system.handler.AbstractSystemEventHandler;
import com.spinyowl.legui.system.handler.SehUtil;
import java.util.Collections;
import java.util.List;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class CursorPosEventHandler
extends AbstractSystemEventHandler<SystemCursorPosEvent> {
    @Override
    protected void preHandle(SystemCursorPosEvent event, Frame frame, Context context) {
        Vector2f cursorPosition = new Vector2f(event.fx, event.fy);
        Mouse.setCursorPositionPrev(new Vector2f((Vector2fc)Mouse.getCursorPosition()));
        Mouse.setCursorPosition(cursorPosition);
        List<Layer> allLayers = frame.getAllLayers();
        Collections.reverse(allLayers);
        Component targetComponent = null;
        for (Layer layer : allLayers) {
            if (layer.isEventReceivable() && layer.isVisible() && layer.isEnabled() && ((targetComponent = SehUtil.getTargetComponent(layer, cursorPosition)) != null || !layer.isEventPassable())) break;
        }
        Component prevTarget = context.getMouseTargetGui();
        context.setMouseTargetGui(targetComponent);
        if (targetComponent != prevTarget) {
            if (targetComponent != null) {
                targetComponent.setHovered(true);
                Vector2f curPosInComponent = targetComponent.getAbsolutePosition().sub((Vector2fc)cursorPosition).negate();
                CursorEnterEvent<Component> enterEvent = new CursorEnterEvent<Component>(targetComponent, context, frame, true, curPosInComponent, cursorPosition);
                EventProcessorProvider.getInstance().pushEvent(enterEvent);
            }
            if (prevTarget != null) {
                Vector2f curPosInPrevTarget = prevTarget.getAbsolutePosition().sub((Vector2fc)cursorPosition).negate();
                CursorEnterEvent<Component> exitEvent = new CursorEnterEvent<Component>(prevTarget, context, frame, false, curPosInPrevTarget, cursorPosition);
                EventProcessorProvider.getInstance().pushEvent(exitEvent);
                prevTarget.setHovered(false);
            }
        }
    }

    @Override
    protected boolean handle(SystemCursorPosEvent event, Layer layer, Context context, Frame frame) {
        List<Component> childComponents = layer.getChildComponents();
        for (Component child : childComponents) {
            this.handle(child, context, frame);
        }
        return false;
    }

    private void handle(Component component, Context context, Frame frame) {
        if (component.isEmpty()) {
            if ((Mouse.MouseButton.MOUSE_BUTTON_LEFT.isPressed() || Mouse.MouseButton.MOUSE_BUTTON_RIGHT.isPressed()) && component == context.getFocusedGui()) {
                Vector2f delta = Mouse.getCursorPosition().sub((Vector2fc)Mouse.getCursorPositionPrev());
                EventProcessorProvider.getInstance().pushEvent(new MouseDragEvent<Component>(component, context, frame, delta));
            }
        } else {
            List<Component> childComponents = component.getChildComponents();
            for (Component child : childComponents) {
                this.handle(child, context, frame);
            }
        }
    }
}

