/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.context;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.config.Configuration;
import com.spinyowl.legui.event.FocusEvent;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.lwjgl.glfw.GLFW;

public class Context {
    private final long glfwWindow;
    private final Map<String, Object> contextData = new ConcurrentHashMap<String, Object>();
    private Vector2f windowPosition;
    private Vector2i windowSize;
    private Vector2i framebufferSize;
    private transient float pixelRatio;
    private Component mouseTargetGui;
    private Component focusedGui;
    private boolean debugEnabled;
    private boolean iconified;

    public Context(long glfwWindow) {
        this.glfwWindow = glfwWindow;
    }

    public static void setFocusedGui(Component toGainFocus, Context context, Frame frame) {
        Component current;
        Component component = current = context == null ? null : context.focusedGui;
        if (current != null) {
            current.setFocused(false);
            EventProcessorProvider.getInstance().pushEvent(new FocusEvent<Component>(current, context, frame, toGainFocus, false));
        }
        if (toGainFocus != null) {
            toGainFocus.setFocused(true);
            EventProcessorProvider.getInstance().pushEvent(new FocusEvent<Component>(toGainFocus, context, frame, toGainFocus, true));
            if (context != null) {
                context.setFocusedGui(toGainFocus);
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public void updateGlfwWindow() {
        int[] windowWidth = new int[]{0};
        int[] windowHeight = new int[]{0};
        int[] frameBufferWidth = new int[]{0};
        int[] frameBufferHeight = new int[]{0};
        int[] xpos = new int[]{0};
        int[] ypos = new int[]{0};
        GLFW.glfwGetWindowSize((long)this.glfwWindow, (int[])windowWidth, (int[])windowHeight);
        GLFW.glfwGetFramebufferSize((long)this.glfwWindow, (int[])frameBufferWidth, (int[])frameBufferHeight);
        GLFW.glfwGetWindowPos((long)this.glfwWindow, (int[])xpos, (int[])ypos);
        this.update(windowWidth[0], windowHeight[0], frameBufferWidth[0], frameBufferHeight[0], xpos[0], ypos[0], GLFW.glfwGetWindowAttrib((long)this.glfwWindow, (int)131074) == 1);
    }

    public void update(int targetWidth, int targetHeight, int framebufferWidth, int framebufferHeight, int targetPosX, int targetPosY, boolean iconified) {
        this.setWindowSize(new Vector2i(targetWidth, targetHeight));
        this.setFramebufferSize(new Vector2i(framebufferWidth, framebufferHeight));
        this.setPixelRatio((float)framebufferWidth / (float)targetWidth);
        this.setWindowPosition(new Vector2f((float)targetPosX, (float)targetPosY));
        this.setIconified(iconified);
    }

    public float getPixelRatio() {
        return this.pixelRatio;
    }

    public void setPixelRatio(float pixelRatio) {
        this.pixelRatio = pixelRatio;
    }

    public long getGlfwWindow() {
        return this.glfwWindow;
    }

    public Vector2f getWindowPosition() {
        return this.windowPosition;
    }

    public void setWindowPosition(Vector2f windowPosition) {
        this.windowPosition = windowPosition;
    }

    public Vector2i getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(Vector2i windowSize) {
        this.windowSize = windowSize;
    }

    public Vector2i getFramebufferSize() {
        return this.framebufferSize;
    }

    public void setFramebufferSize(Vector2i framebufferSize) {
        this.framebufferSize = framebufferSize;
    }

    public Component getFocusedGui() {
        return this.focusedGui;
    }

    public void setFocusedGui(Component focusedGui) {
        this.focusedGui = focusedGui;
    }

    public Component getMouseTargetGui() {
        return this.mouseTargetGui;
    }

    public void setMouseTargetGui(Component mouseTargetGui) {
        this.mouseTargetGui = mouseTargetGui;
    }

    public boolean isIconified() {
        return this.iconified;
    }

    public void setIconified(boolean iconified) {
        this.iconified = iconified;
    }

    static {
        Configuration.getInstance();
    }
}

