/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.style.util;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.length.Length;
import com.spinyowl.legui.style.length.LengthType;
import com.spinyowl.legui.style.length.Unit;
import java.util.function.Function;
import org.joml.Vector2f;
import org.joml.Vector4f;

public final class StyleUtilities {
    private StyleUtilities() {
    }

    public static Vector4f getPadding(Component component, Style style) {
        Length paddingLeft = style.getPaddingLeft();
        Length paddingRight = style.getPaddingRight();
        Length paddingTop = style.getPaddingTop();
        Length paddingBottom = style.getPaddingBottom();
        float baseWidth = 0.0f;
        baseWidth = component.getParent() != null ? component.getParent().getSize().x : component.getSize().x;
        return new Vector4f(StyleUtilities.getFloatLengthNullSafe(paddingLeft, baseWidth), StyleUtilities.getFloatLengthNullSafe(paddingTop, baseWidth), StyleUtilities.getFloatLengthNullSafe(paddingRight, baseWidth), StyleUtilities.getFloatLengthNullSafe(paddingBottom, baseWidth));
    }

    public static float getFloatLengthNullSafe(Unit length, float baseWidth) {
        Float floatLength = StyleUtilities.getFloatLength(length, baseWidth);
        return floatLength == null ? 0.0f : floatLength.floatValue();
    }

    public static Float getFloatLength(Unit length, float baseWidth) {
        if (length == null) {
            return null;
        }
        if (length.isAuto()) {
            return Float.valueOf(baseWidth);
        }
        if (length.isLength()) {
            Length l = length.asLength();
            if (LengthType.PIXEL.equals(l.type())) {
                return LengthType.PIXEL.type().cast(l.get());
            }
            if (LengthType.PERCENT.equals(l.type())) {
                return Float.valueOf(LengthType.PERCENT.type().cast(l.get()).floatValue() * baseWidth / 100.0f);
            }
        }
        return null;
    }

    public static Vector4f getInnerContentRectangle(Vector2f componentPosition, Vector2f componentSize, Vector4f componentPadding) {
        return new Vector4f(componentPosition.x + componentPadding.x, componentPosition.y + componentPadding.y, componentSize.x - componentPadding.x - componentPadding.z, componentSize.y - componentPadding.y - componentPadding.w);
    }

    public static Vector4f getBorderRadius(Component component, Style style) {
        Length borderTopLeftRadius = style.getBorderTopLeftRadius();
        Length borderTopRightRadius = style.getBorderTopRightRadius();
        Length borderBottomRightRadius = style.getBorderBottomRightRadius();
        Length borderBottomLeftRadius = style.getBorderBottomLeftRadius();
        return new Vector4f(StyleUtilities.getFloatLengthNullSafe(borderTopLeftRadius, component.getSize().x), StyleUtilities.getFloatLengthNullSafe(borderTopRightRadius, component.getSize().x), StyleUtilities.getFloatLengthNullSafe(borderBottomRightRadius, component.getSize().x), StyleUtilities.getFloatLengthNullSafe(borderBottomLeftRadius, component.getSize().x));
    }

    public static <T> T getStyle(Component component, Function<Style, T> getter) {
        return StyleUtilities.getStyle(component, getter, null);
    }

    public static <T> T getStyle(Component component, Function<Style, T> getter, T defaultValue) {
        T value;
        Style style = component.getStyle();
        T general = getter.apply(style);
        T t = value = general == null ? defaultValue : general;
        if (component.isFocused() && getter.apply(component.getFocusedStyle()) != null) {
            value = getter.apply(component.getFocusedStyle());
        }
        if (component.isHovered() && getter.apply(component.getHoveredStyle()) != null) {
            value = getter.apply(component.getHoveredStyle());
        }
        if (component.isPressed() && getter.apply(component.getPressedStyle()) != null) {
            value = getter.apply(component.getPressedStyle());
        }
        return value;
    }
}

