/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.style.font;

import com.spinyowl.legui.exception.LeguiExceptionTemplate;
import com.spinyowl.legui.style.font.Font;
import com.spinyowl.legui.util.IOUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class FontRegistry {
    public static final String ENTYPO = "entypo";
    public static final String ROBOTO_BOLD = "roboto-bold";
    public static final String ROBOTO_LIGHT = "roboto-light";
    public static final String ROBOTO_REGULAR = "roboto-regular";
    public static final String MATERIAL_ICONS_REGULAR = "MaterialIcons-Regular";
    public static final String FONT_AWESOME_ICONS = "FontAwesomeIcons";
    public static final String MATERIAL_DESIGN_ICONS = "materialdesignicons";
    private static final Map<String, Font> fontRegister = new ConcurrentHashMap<String, Font>();
    private static String defaultFont = "roboto-light";

    private FontRegistry() {
    }

    public static String getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(String defaultFont) {
        FontRegistry.defaultFont = Objects.requireNonNull(defaultFont);
    }

    public static void registerFont(String name, String path) {
        try {
            fontRegister.put(name, new Font(path, IOUtil.resourceToByteBuffer(path)));
        }
        catch (IOException e) {
            throw LeguiExceptionTemplate.FAILED_TO_LOAD_FONT.create(e, path);
        }
    }

    public static void registerFontSafe(String name, String path) {
        try {
            FontRegistry.registerFont(name, path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Font> getFontRegister() {
        return new HashMap<String, Font>(fontRegister);
    }

    public static Font getFont(String name) {
        return fontRegister.get(name);
    }

    static {
        FontRegistry.registerFontSafe(ENTYPO, "com/spinyowl/legui/style/font/entypo.ttf");
        FontRegistry.registerFontSafe(ROBOTO_BOLD, "com/spinyowl/legui/style/font/Roboto-Bold.ttf");
        FontRegistry.registerFontSafe(ROBOTO_LIGHT, "com/spinyowl/legui/style/font/Roboto-Light.ttf");
        FontRegistry.registerFontSafe(ROBOTO_REGULAR, "com/spinyowl/legui/style/font/Roboto-Regular.ttf");
        FontRegistry.registerFontSafe(MATERIAL_ICONS_REGULAR, "com/spinyowl/legui/style/font/MaterialIcons-Regular.ttf");
        FontRegistry.registerFontSafe(FONT_AWESOME_ICONS, "com/spinyowl/legui/style/font/FontAwesome.otf");
        FontRegistry.registerFontSafe(MATERIAL_DESIGN_ICONS, "com/spinyowl/legui/style/font/materialdesignicons.ttf");
    }
}

