/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.style.color;

import com.spinyowl.legui.style.color.ColorConstants;
import java.util.Random;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public final class ColorUtil {
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    private ColorUtil() {
    }

    public static Vector4f negativeColor(Vector4f color) {
        Vector4f dest = new Vector4f(1.0f).sub((Vector4fc)color);
        dest.w = color.w;
        return dest;
    }

    public static void negativeColor(Vector4f color, Vector4f dest) {
        dest.zero().set(1.0f).sub((Vector4fc)color);
        dest.w = color.w;
    }

    public static Vector4f negativeColorRGB(Vector4f color) {
        Vector4f dest = new Vector4f(1.0f).sub((Vector4fc)color);
        dest.w = 1.0f;
        return dest;
    }

    public static Vector4f negativeColorRGB(Vector4f color, Vector4f dest) {
        dest.zero().set(1.0f).sub((Vector4fc)color);
        dest.w = 1.0f;
        return dest;
    }

    public static Vector4f half(Vector4f color) {
        return new Vector4f((Vector4fc)color).div(2.0f);
    }

    public static Vector4f halfRGB(Vector4f color) {
        return new Vector4f(color.x / 2.0f, color.y / 2.0f, color.z / 2.0f, color.w);
    }

    public static Vector4f oppositeBlackOrWhite(Vector4f color) {
        return ColorUtil.oppositeBlackOrWhite(color, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
    }

    public static Vector4f oppositeBlackOrWhite(Vector4f color, Vector4f targetColor) {
        if (color.w == 0.0f) {
            return ColorConstants.gray();
        }
        if (color.x * 0.299f + color.y * 0.587f + color.z * 0.114f > 0.6666667f) {
            targetColor.x = 0.0f;
            targetColor.y = 0.0f;
            targetColor.z = 0.0f;
        } else {
            targetColor.x = 1.0f;
            targetColor.y = 1.0f;
            targetColor.z = 1.0f;
        }
        return targetColor;
    }

    public static Vector4f fromInt(int r, int g, int b, float a) {
        return new Vector4f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, a);
    }

    public static Vector4f randomColor() {
        return new Vector4f(RANDOM.nextFloat(), RANDOM.nextFloat(), RANDOM.nextFloat(), 1.0f);
    }
}

