/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.input;

import com.spinyowl.legui.input.KeyCode;
import com.spinyowl.legui.input.KeyMod;
import com.spinyowl.legui.input.Shortcut;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public final class Keyboard {
    private static final BidiMap<KeyCode, Integer> keys = new DualHashBidiMap();
    private static Shortcut copyShortcut = new Shortcut(KeyCode.KEY_C, KeyMod.CONTROL);
    private static Shortcut pasteShortcut = new Shortcut(KeyCode.KEY_V, KeyMod.CONTROL);
    private static Shortcut selectAllShortcut = new Shortcut(KeyCode.KEY_A, KeyMod.CONTROL);
    private static Shortcut cutShortcut = new Shortcut(KeyCode.KEY_X, KeyMod.CONTROL);

    private Keyboard() {
    }

    public static void updateMapping(Map<KeyCode, Integer> keyMapping) {
        keys.putAll(keyMapping);
    }

    public static KeyCode getKeyCode(int nativeCode) {
        return (KeyCode)((Object)keys.getKey((Object)nativeCode));
    }

    public static int getNativeCode(KeyCode keyCode) {
        return (Integer)keys.get((Object)keyCode);
    }

    public static Shortcut getCopyShortcut() {
        return copyShortcut;
    }

    public static void setCopyShortcut(Shortcut copyShortcut) {
        Keyboard.copyShortcut = Objects.requireNonNull(copyShortcut);
    }

    public static Shortcut getPasteShortcut() {
        return pasteShortcut;
    }

    public static void setPasteShortcut(Shortcut pasteShortcut) {
        Keyboard.pasteShortcut = Objects.requireNonNull(pasteShortcut);
    }

    public static Shortcut getSelectAllShortcut() {
        return selectAllShortcut;
    }

    public static void setSelectAllShortcut(Shortcut selectAllShortcut) {
        Keyboard.selectAllShortcut = Objects.requireNonNull(selectAllShortcut);
    }

    public static Shortcut getCutShortcut() {
        return cutShortcut;
    }

    public static void setCutShortcut(Shortcut cutShortcut) {
        Keyboard.cutShortcut = Objects.requireNonNull(cutShortcut);
    }

    static {
        keys.put((Object)KeyCode.UNKNOWN, (Object)-1);
        keys.put((Object)KeyCode.SPACE, (Object)32);
        keys.put((Object)KeyCode.APOSTROPHE, (Object)39);
        keys.put((Object)KeyCode.COMMA, (Object)44);
        keys.put((Object)KeyCode.MINUS, (Object)45);
        keys.put((Object)KeyCode.PERIOD, (Object)46);
        keys.put((Object)KeyCode.SLASH, (Object)47);
        keys.put((Object)KeyCode.KEY_0, (Object)48);
        keys.put((Object)KeyCode.KEY_1, (Object)49);
        keys.put((Object)KeyCode.KEY_2, (Object)50);
        keys.put((Object)KeyCode.KEY_3, (Object)51);
        keys.put((Object)KeyCode.KEY_4, (Object)52);
        keys.put((Object)KeyCode.KEY_5, (Object)53);
        keys.put((Object)KeyCode.KEY_6, (Object)54);
        keys.put((Object)KeyCode.KEY_7, (Object)55);
        keys.put((Object)KeyCode.KEY_8, (Object)56);
        keys.put((Object)KeyCode.KEY_9, (Object)57);
        keys.put((Object)KeyCode.SEMICOLON, (Object)59);
        keys.put((Object)KeyCode.EQUAL, (Object)61);
        keys.put((Object)KeyCode.KEY_A, (Object)65);
        keys.put((Object)KeyCode.KEY_B, (Object)66);
        keys.put((Object)KeyCode.KEY_C, (Object)67);
        keys.put((Object)KeyCode.KEY_D, (Object)68);
        keys.put((Object)KeyCode.KEY_E, (Object)69);
        keys.put((Object)KeyCode.KEY_F, (Object)70);
        keys.put((Object)KeyCode.KEY_G, (Object)71);
        keys.put((Object)KeyCode.KEY_H, (Object)72);
        keys.put((Object)KeyCode.KEY_I, (Object)73);
        keys.put((Object)KeyCode.KEY_J, (Object)74);
        keys.put((Object)KeyCode.KEY_K, (Object)75);
        keys.put((Object)KeyCode.KEY_L, (Object)76);
        keys.put((Object)KeyCode.KEY_M, (Object)77);
        keys.put((Object)KeyCode.KEY_N, (Object)78);
        keys.put((Object)KeyCode.KEY_O, (Object)79);
        keys.put((Object)KeyCode.KEY_P, (Object)80);
        keys.put((Object)KeyCode.KEY_Q, (Object)81);
        keys.put((Object)KeyCode.KEY_R, (Object)82);
        keys.put((Object)KeyCode.KEY_S, (Object)83);
        keys.put((Object)KeyCode.KEY_T, (Object)84);
        keys.put((Object)KeyCode.KEY_U, (Object)85);
        keys.put((Object)KeyCode.KEY_V, (Object)86);
        keys.put((Object)KeyCode.KEY_W, (Object)87);
        keys.put((Object)KeyCode.KEY_X, (Object)88);
        keys.put((Object)KeyCode.KEY_Y, (Object)89);
        keys.put((Object)KeyCode.KEY_Z, (Object)90);
        keys.put((Object)KeyCode.LEFT_BRACKET, (Object)91);
        keys.put((Object)KeyCode.BACKSLASH, (Object)92);
        keys.put((Object)KeyCode.RIGHT_BRACKET, (Object)93);
        keys.put((Object)KeyCode.GRAVE_ACCENT, (Object)96);
        keys.put((Object)KeyCode.WORLD_1, (Object)161);
        keys.put((Object)KeyCode.WORLD_2, (Object)162);
        keys.put((Object)KeyCode.ESCAPE, (Object)256);
        keys.put((Object)KeyCode.ENTER, (Object)257);
        keys.put((Object)KeyCode.TAB, (Object)258);
        keys.put((Object)KeyCode.BACKSPACE, (Object)259);
        keys.put((Object)KeyCode.INSERT, (Object)260);
        keys.put((Object)KeyCode.DELETE, (Object)261);
        keys.put((Object)KeyCode.RIGHT, (Object)262);
        keys.put((Object)KeyCode.LEFT, (Object)263);
        keys.put((Object)KeyCode.DOWN, (Object)264);
        keys.put((Object)KeyCode.UP, (Object)265);
        keys.put((Object)KeyCode.PAGE_UP, (Object)266);
        keys.put((Object)KeyCode.PAGE_DOWN, (Object)267);
        keys.put((Object)KeyCode.HOME, (Object)268);
        keys.put((Object)KeyCode.END, (Object)269);
        keys.put((Object)KeyCode.CAPS_LOCK, (Object)280);
        keys.put((Object)KeyCode.SCROLL_LOCK, (Object)281);
        keys.put((Object)KeyCode.NUM_LOCK, (Object)282);
        keys.put((Object)KeyCode.PRINT_SCREEN, (Object)283);
        keys.put((Object)KeyCode.PAUSE, (Object)284);
        keys.put((Object)KeyCode.KEY_F1, (Object)290);
        keys.put((Object)KeyCode.KEY_F2, (Object)291);
        keys.put((Object)KeyCode.KEY_F3, (Object)292);
        keys.put((Object)KeyCode.KEY_F4, (Object)293);
        keys.put((Object)KeyCode.KEY_F5, (Object)294);
        keys.put((Object)KeyCode.KEY_F6, (Object)295);
        keys.put((Object)KeyCode.KEY_F7, (Object)296);
        keys.put((Object)KeyCode.KEY_F8, (Object)297);
        keys.put((Object)KeyCode.KEY_F9, (Object)298);
        keys.put((Object)KeyCode.KEY_F10, (Object)299);
        keys.put((Object)KeyCode.KEY_F11, (Object)300);
        keys.put((Object)KeyCode.KEY_F12, (Object)301);
        keys.put((Object)KeyCode.KEY_F13, (Object)302);
        keys.put((Object)KeyCode.KEY_F14, (Object)303);
        keys.put((Object)KeyCode.KEY_F15, (Object)304);
        keys.put((Object)KeyCode.KEY_F16, (Object)305);
        keys.put((Object)KeyCode.KEY_F17, (Object)306);
        keys.put((Object)KeyCode.KEY_F18, (Object)307);
        keys.put((Object)KeyCode.KEY_F19, (Object)308);
        keys.put((Object)KeyCode.KEY_F20, (Object)309);
        keys.put((Object)KeyCode.KEY_F21, (Object)310);
        keys.put((Object)KeyCode.KEY_F22, (Object)311);
        keys.put((Object)KeyCode.KEY_F23, (Object)312);
        keys.put((Object)KeyCode.KEY_F24, (Object)313);
        keys.put((Object)KeyCode.KEY_F25, (Object)314);
        keys.put((Object)KeyCode.NUMPAD_0, (Object)320);
        keys.put((Object)KeyCode.NUMPAD_1, (Object)321);
        keys.put((Object)KeyCode.NUMPAD_2, (Object)322);
        keys.put((Object)KeyCode.NUMPAD_3, (Object)323);
        keys.put((Object)KeyCode.NUMPAD_4, (Object)324);
        keys.put((Object)KeyCode.NUMPAD_5, (Object)325);
        keys.put((Object)KeyCode.NUMPAD_6, (Object)326);
        keys.put((Object)KeyCode.NUMPAD_7, (Object)327);
        keys.put((Object)KeyCode.NUMPAD_8, (Object)328);
        keys.put((Object)KeyCode.NUMPAD_9, (Object)329);
        keys.put((Object)KeyCode.NUMPAD_DECIMAL, (Object)330);
        keys.put((Object)KeyCode.NUMPAD_DIVIDE, (Object)331);
        keys.put((Object)KeyCode.NUMPAD_MULTIPLY, (Object)332);
        keys.put((Object)KeyCode.NUMPAD_SUBTRACT, (Object)333);
        keys.put((Object)KeyCode.NUMPAD_ADD, (Object)334);
        keys.put((Object)KeyCode.NUMPAD_ENTER, (Object)335);
        keys.put((Object)KeyCode.NUMPAD_EQUAL, (Object)336);
        keys.put((Object)KeyCode.LEFT_SHIFT, (Object)340);
        keys.put((Object)KeyCode.LEFT_CONTROL, (Object)341);
        keys.put((Object)KeyCode.LEFT_ALT, (Object)342);
        keys.put((Object)KeyCode.LEFT_SUPER, (Object)343);
        keys.put((Object)KeyCode.RIGHT_SHIFT, (Object)344);
        keys.put((Object)KeyCode.RIGHT_CONTROL, (Object)345);
        keys.put((Object)KeyCode.RIGHT_ALT, (Object)346);
        keys.put((Object)KeyCode.RIGHT_SUPER, (Object)347);
        keys.put((Object)KeyCode.KEY_MENU, (Object)348);
    }
}

