/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.image;

import com.spinyowl.legui.exception.LeguiExceptionTemplate;
import com.spinyowl.legui.image.ImageChannels;
import com.spinyowl.legui.image.LoadableImage;
import com.spinyowl.legui.util.IOUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.lwjgl.stb.STBImage;

public class StbBackedLoadableImage
extends LoadableImage {
    private int width;
    private int height;
    private ImageChannels channels;
    private ByteBuffer imageData;

    public StbBackedLoadableImage(String path) {
        super(path);
    }

    @Override
    public void load() {
        try {
            ByteBuffer byteBuffer = IOUtil.resourceToByteBuffer(this.getPath());
            int[] w = new int[]{0};
            int[] h = new int[]{0};
            int[] c = new int[]{0};
            ByteBuffer buffer = STBImage.stbi_load_from_memory((ByteBuffer)byteBuffer, (int[])w, (int[])h, (int[])c, (int)4);
            if (buffer == null) {
                throw LeguiExceptionTemplate.FAILED_TO_LOAD_IMAGE.create(STBImage.stbi_failure_reason());
            }
            this.width = w[0];
            this.height = h[0];
            this.channels = ImageChannels.instance(c[0]);
            this.imageData = buffer;
        }
        catch (IOException e) {
            throw LeguiExceptionTemplate.FAILED_TO_LOAD_IMAGE.create(e, e.getMessage());
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getImageData() {
        return this.imageData;
    }

    @Override
    public ImageChannels getChannels() {
        return this.channels;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("path", (Object)this.getPath()).append("width", this.width).append("height", this.height).append("channels", (Object)this.channels).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StbBackedLoadableImage image = (StbBackedLoadableImage)obj;
        return new EqualsBuilder().append(this.width, image.width).append(this.height, image.height).append((Object)this.getPath(), (Object)image.getPath()).append((Object)this.channels, (Object)image.channels).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getPath()).append(this.width).append(this.height).append((Object)this.channels).toHashCode();
    }
}

