/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.image;

import com.spinyowl.legui.image.Image;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class BufferedImageRGBA
extends Image {
    private final ByteBuffer[] byteBuffers = new ByteBuffer[2];
    private final AtomicBoolean needToRead = new AtomicBoolean(false);
    private final int width;
    private final int height;
    private final int dataSize;
    private volatile int readPB = 1;
    private volatile int writePB = 0;

    public BufferedImageRGBA(int width, int height) {
        this.width = width;
        this.height = height;
        this.dataSize = width * height * 4;
        this.byteBuffers[0] = ByteBuffer.allocateDirect(this.dataSize);
        this.byteBuffers[1] = ByteBuffer.allocateDirect(this.dataSize);
        for (ByteBuffer byteBuffer : this.byteBuffers) {
            for (int i = 0; i < this.dataSize; ++i) {
                byteBuffer.put((byte)(i % 255));
            }
        }
    }

    public void updateImageData(ByteBuffer data) {
        if (data.capacity() != this.dataSize) {
            throw new IllegalArgumentException("Wrong size of data");
        }
        ByteBuffer buffer = this.byteBuffers[this.writePB];
        buffer.clear();
        buffer.put(data);
        buffer.rewind();
        int tmp = this.writePB;
        this.writePB = this.readPB;
        this.readPB = tmp;
        this.needToRead.set(true);
    }

    public boolean isUpdated() {
        return this.needToRead.get();
    }

    public ByteBuffer getImageData() {
        return this.byteBuffers[this.readPB];
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

