/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.event;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.event.Event;
import com.spinyowl.legui.input.Mouse;
import com.spinyowl.legui.system.context.Context;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;

public class MouseClickEvent<T extends Component>
extends Event<T> {
    private final MouseClickAction action;
    private final Mouse.MouseButton button;
    private final Vector2f position;
    private final Vector2f absolutePosition;
    private final int mods;

    public MouseClickEvent(T component, Context context, Frame frame, MouseClickAction action, Mouse.MouseButton button, Vector2f position, Vector2f absolutePosition, int mods) {
        super(component, context, frame);
        this.action = action;
        this.button = button;
        this.position = position;
        this.absolutePosition = absolutePosition;
        this.mods = mods;
    }

    public MouseClickAction getAction() {
        return this.action;
    }

    public Mouse.MouseButton getButton() {
        return this.button;
    }

    public Vector2f getPosition() {
        return this.position;
    }

    public Vector2f getAbsolutePosition() {
        return this.absolutePosition;
    }

    public int getMods() {
        return this.mods;
    }

    public boolean isModShift() {
        return (this.mods & 1) != 0;
    }

    public boolean isModControl() {
        return (this.mods & 2) != 0;
    }

    public boolean isModAlt() {
        return (this.mods & 4) != 0;
    }

    public boolean isModSuper() {
        return (this.mods & 8) != 0;
    }

    public boolean isModCapsLock() {
        return (this.mods & 0x10) != 0;
    }

    public boolean isModNumLock() {
        return (this.mods & 0x20) != 0;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("targetComponent", (Object)this.getTargetComponent().getClass().getSimpleName()).append("action", (Object)this.action).append("button", (Object)this.button).append("position", (Object)this.position).append("absolutePosition", (Object)this.absolutePosition).append("mods", this.mods).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MouseClickEvent that = (MouseClickEvent)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.mods, that.mods).append((Object)this.action, (Object)that.action).append((Object)this.button, (Object)that.button).append((Object)this.position, (Object)that.position).append((Object)this.absolutePosition, (Object)that.absolutePosition).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.action).append((Object)this.button).append((Object)this.position).append((Object)this.absolutePosition).append(this.mods).toHashCode();
    }

    public static enum MouseClickAction {
        PRESS,
        CLICK,
        RELEASE;

    }
}

