/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.cursor;

import com.spinyowl.legui.cursor.Cursor;
import com.spinyowl.legui.cursor.CursorService;
import com.spinyowl.legui.system.context.Context;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lwjgl.glfw.GLFW;

public class GLFWCursorServiceImpl
implements CursorService {
    private Map<Cursor, Long> cursors = new ConcurrentHashMap<Cursor, Long>();

    private static Long createCursor(Cursor cs) {
        return GLFW.nglfwCreateCursor((long)cs.getImageReference(), (int)cs.getxHot(), (int)cs.getyHot());
    }

    @Override
    public void setCursor(Cursor cursor, Context context) {
        if (cursor == null) {
            return;
        }
        if (cursor == Cursor.ARROW) {
            GLFW.glfwSetCursor((long)context.getGlfwWindow(), (long)GLFW.glfwCreateStandardCursor((int)221185));
            return;
        }
        if (cursor == Cursor.H_RESIZE) {
            GLFW.glfwSetCursor((long)context.getGlfwWindow(), (long)GLFW.glfwCreateStandardCursor((int)221189));
            return;
        }
        if (cursor == Cursor.V_RESIZE) {
            GLFW.glfwSetCursor((long)context.getGlfwWindow(), (long)GLFW.glfwCreateStandardCursor((int)221190));
            return;
        }
        if (cursor == Cursor.CROSSHAIR) {
            GLFW.glfwSetCursor((long)context.getGlfwWindow(), (long)GLFW.glfwCreateStandardCursor((int)221187));
            return;
        }
        if (cursor == Cursor.HAND) {
            GLFW.glfwSetCursor((long)context.getGlfwWindow(), (long)GLFW.glfwCreateStandardCursor((int)221188));
            return;
        }
        if (cursor == Cursor.IBEAM) {
            GLFW.glfwSetCursor((long)context.getGlfwWindow(), (long)GLFW.glfwCreateStandardCursor((int)221186));
            return;
        }
        GLFW.glfwSetCursor((long)context.getGlfwWindow(), (long)this.cursors.computeIfAbsent(cursor, GLFWCursorServiceImpl::createCursor));
    }
}

