/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.config;

import com.spinyowl.legui.input.KeyCode;
import com.spinyowl.legui.input.Keyboard;
import com.spinyowl.legui.input.Shortcut;
import com.spinyowl.legui.util.IOUtil;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public class Configuration {
    private static Configuration instance;
    private String keyboardLayout;
    private Shortcuts shortcuts;
    private Map<String, Map<KeyCode, Integer>> keyboardLayouts;

    private static void initialize() {
        Moshi moshi = new Moshi.Builder().build();
        JsonAdapter configurationAdapter = moshi.adapter(Configuration.class);
        ParameterizedType mapType = Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Object.class});
        JsonAdapter mapAdapter = moshi.adapter((Type)mapType);
        try {
            Map<String, Object> initialJson = Configuration.getJson("defaultLegui.json", (JsonAdapter<Map<String, Object>>)mapAdapter, Map.of());
            Map<String, Object> importedJson = Configuration.getJson("legui.json", (JsonAdapter<Map<String, Object>>)mapAdapter, null);
            Configuration.merge(initialJson, importedJson);
            String mergedJson = mapAdapter.toJson(initialJson);
            Configuration configuration = (Configuration)configurationAdapter.fromJson(mergedJson);
            if (configuration != null) {
                configuration.updateKeyboard();
                instance = configuration;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Object> getJson(String path, JsonAdapter<Map<String, Object>> adapter, Map<String, Object> defaultJson) {
        try {
            String json = IOUtil.resourceToString(path);
            return (Map)adapter.fromJson(json);
        }
        catch (IOException e) {
            e.printStackTrace();
            return defaultJson;
        }
    }

    private static Map<String, Object> merge(Map<String, Object> left, Map<String, Object> right) {
        if (right == null) {
            return left;
        }
        for (Map.Entry<String, Object> importedEntry : right.entrySet()) {
            left.merge(importedEntry.getKey(), importedEntry.getValue(), (leftChild, rightChild) -> {
                if (leftChild instanceof Map && rightChild instanceof Map) {
                    return Configuration.merge((Map)leftChild, (Map)rightChild);
                }
                return rightChild;
            });
        }
        return left;
    }

    public static Configuration getInstance() {
        return instance;
    }

    public static void setInstance(Configuration instance) {
        Configuration.instance = instance;
    }

    private void updateKeyboard() {
        Shortcut selectAll;
        Shortcut paste;
        Shortcut cut;
        Shortcut copy;
        Map<KeyCode, Integer> mapping = this.getKeyboardLayouts().get(this.getKeyboardLayout());
        if (mapping != null) {
            Keyboard.updateMapping(mapping);
        }
        if ((copy = this.getShortcuts().getCopy()) != null) {
            Keyboard.setCopyShortcut(copy);
        }
        if ((cut = this.getShortcuts().getCut()) != null) {
            Keyboard.setCutShortcut(cut);
        }
        if ((paste = this.getShortcuts().getPaste()) != null) {
            Keyboard.setPasteShortcut(paste);
        }
        if ((selectAll = this.getShortcuts().getSelectAll()) != null) {
            Keyboard.setSelectAllShortcut(selectAll);
        }
    }

    public String getKeyboardLayout() {
        return this.keyboardLayout;
    }

    public void setKeyboardLayout(String keyboardLayout) {
        this.keyboardLayout = keyboardLayout;
    }

    public Map<String, Map<KeyCode, Integer>> getKeyboardLayouts() {
        return this.keyboardLayouts;
    }

    public void setKeyboardLayouts(Map<String, Map<KeyCode, Integer>> keyboardLayouts) {
        this.keyboardLayouts = keyboardLayouts;
    }

    public Shortcuts getShortcuts() {
        return this.shortcuts;
    }

    public void setShortcuts(Shortcuts shortcuts) {
        this.shortcuts = shortcuts;
    }

    static {
        Configuration.initialize();
    }

    public static class Shortcuts {
        private Shortcut copy;
        private Shortcut paste;
        private Shortcut cut;
        private Shortcut selectAll;

        public Shortcut getCopy() {
            return this.copy;
        }

        public void setCopy(Shortcut copy) {
            this.copy = copy;
        }

        public Shortcut getPaste() {
            return this.paste;
        }

        public void setPaste(Shortcut paste) {
            this.paste = paste;
        }

        public Shortcut getCut() {
            return this.cut;
        }

        public void setCut(Shortcut cut) {
            this.cut = cut;
        }

        public Shortcut getSelectAll() {
            return this.selectAll;
        }

        public void setSelectAll(Shortcut selectAll) {
            this.selectAll = selectAll;
        }
    }
}

