/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.optional;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TextState
implements Serializable {
    public static final Predicate<String> INTEGER_VALIDATOR = s -> s.matches("-?\\d+");
    public static final Predicate<String> NUMBER_VALIDATOR = s -> s.matches("-?\\d+(\\.\\d+)?");
    private String text = "";
    private int caretPosition;
    private int mouseCaretPosition;
    private int startSelectionIndex;
    private int endSelectionIndex;
    private boolean editable = true;
    private float textWidth;
    private float textHeight;
    private Float caretX;
    private Float caretY;
    private BiConsumer<String, String> textSetCallback;
    private Predicate<String> validator;

    public TextState() {
        this("", null);
    }

    public TextState(String text) {
        this(text, null);
    }

    public TextState(BiConsumer<String, String> textSetCallback) {
        this("", textSetCallback);
    }

    public TextState(String text, BiConsumer<String, String> textSetCallback) {
        this.textSetCallback = textSetCallback;
        this.setText(text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.validator != null && !this.validator.test(text)) {
            return;
        }
        String oldValue = this.text;
        String newValue = text;
        this.text = text != null ? text : "";
        this.endSelectionIndex = 0;
        this.startSelectionIndex = 0;
        this.caretPosition = 0;
        if (this.textSetCallback != null) {
            this.textSetCallback.accept(oldValue, newValue);
        }
    }

    public int length() {
        return this.text.length();
    }

    public int getMouseCaretPosition() {
        return this.mouseCaretPosition;
    }

    public void setMouseCaretPosition(int mouseCaretPosition) {
        this.mouseCaretPosition = mouseCaretPosition;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public void setCaretPosition(int caretPosition) {
        int length = this.text.length();
        this.caretPosition = caretPosition < 0 ? 0 : (caretPosition > length ? length : caretPosition);
    }

    public int getStartSelectionIndex() {
        return this.startSelectionIndex;
    }

    public void setStartSelectionIndex(int startSelectionIndex) {
        this.startSelectionIndex = startSelectionIndex;
    }

    public int getEndSelectionIndex() {
        return this.endSelectionIndex;
    }

    public void setEndSelectionIndex(int endSelectionIndex) {
        this.endSelectionIndex = endSelectionIndex;
    }

    public String getSelection() {
        if (this.startSelectionIndex < 0 || this.endSelectionIndex < 0) {
            return null;
        }
        String selection = this.startSelectionIndex > this.endSelectionIndex ? this.text.substring(this.endSelectionIndex, this.startSelectionIndex) : this.text.substring(this.startSelectionIndex, this.endSelectionIndex);
        return selection;
    }

    public float getTextWidth() {
        return this.textWidth;
    }

    public void setTextWidth(float textWidth) {
        this.textWidth = textWidth;
    }

    public float getTextHeight() {
        return this.textHeight;
    }

    public void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    public Float getCaretX() {
        return this.caretX;
    }

    public void setCaretX(Float caretX) {
        this.caretX = caretX;
    }

    public Float getCaretY() {
        return this.caretY;
    }

    public void setCaretY(Float caretY) {
        this.caretY = caretY;
    }

    public BiConsumer<String, String> getTextSetCallback() {
        return this.textSetCallback;
    }

    public void setTextSetCallback(BiConsumer<String, String> textSetCallback) {
        this.textSetCallback = textSetCallback;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextState textState = (TextState)o;
        return this.caretPosition == textState.caretPosition && this.mouseCaretPosition == textState.mouseCaretPosition && this.startSelectionIndex == textState.startSelectionIndex && this.endSelectionIndex == textState.endSelectionIndex && this.editable == textState.editable && Objects.equals(this.text, textState.text);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.caretPosition, this.mouseCaretPosition, this.startSelectionIndex, this.endSelectionIndex, this.editable);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("text", (Object)this.text).append("caretPosition", this.caretPosition).append("mouseCaretPosition", this.mouseCaretPosition).append("startSelectionIndex", this.startSelectionIndex).append("endSelectionIndex", this.endSelectionIndex).append("editable", this.editable).toString();
    }

    public Predicate<String> getValidator() {
        return this.validator;
    }

    public void setValidator(Predicate<String> validator) {
        this.validator = validator;
    }
}

