/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.listener.widget;

import com.spinyowl.legui.component.Button;
import com.spinyowl.legui.component.Widget;
import com.spinyowl.legui.component.event.component.ChangeSizeEvent;
import com.spinyowl.legui.event.MouseDragEvent;
import com.spinyowl.legui.input.Mouse;
import com.spinyowl.legui.listener.MouseDragEventListener;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.style.length.Length;
import com.spinyowl.legui.style.length.LengthType;
import com.spinyowl.legui.style.util.StyleUtilities;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class WidgetResizeButtonDragListener
implements MouseDragEventListener {
    public static final float THRESHOLD = 1.0E-4f;
    private Button resizeButton;
    private Widget widget;

    public WidgetResizeButtonDragListener(Button resizeButton, Widget widget) {
        this.resizeButton = resizeButton;
        this.widget = widget;
    }

    @Override
    public void process(MouseDragEvent event) {
        Length<Float> minHeightU;
        Vector2f delta = event.getDelta();
        Vector2f cursorPositionPrev = Mouse.getCursorPositionPrev();
        Vector2f cursorPosition = Mouse.getCursorPosition();
        float xx = this.widget.getSize().x + delta.x;
        float yy = this.widget.getSize().y + delta.y;
        Vector2f deltaSize = new Vector2f();
        Length<Float> minWidthU = this.widget.getStyle().getMinWidth();
        if (minWidthU == null) {
            minWidthU = LengthType.pixel(1.0f);
        }
        if ((minHeightU = this.widget.getStyle().getMinHeight()) == null) {
            minHeightU = LengthType.pixel(this.widget.getTitleContainer().getSize().y);
        }
        Length maxWidthU = this.widget.getStyle().getMaxWidth();
        Length maxHeightU = this.widget.getStyle().getMaxHeight();
        Float minWidth = StyleUtilities.getFloatLength(minWidthU, this.widget.getParent().getSize().x);
        Float minHeight = StyleUtilities.getFloatLength(minHeightU, this.widget.getParent().getSize().y);
        Float maxWidth = StyleUtilities.getFloatLength(maxWidthU, this.widget.getParent().getSize().x);
        Float maxHeight = StyleUtilities.getFloatLength(maxHeightU, this.widget.getParent().getSize().y);
        if ((delta.x < 0.0f && (cursorPositionPrev.x <= this.resizeButton.getAbsolutePosition().x + this.resizeButton.getSize().x || cursorPosition.x <= this.resizeButton.getAbsolutePosition().x + this.resizeButton.getSize().x) || delta.x > 0.0f && (cursorPositionPrev.x >= this.resizeButton.getAbsolutePosition().x || cursorPosition.x >= this.resizeButton.getAbsolutePosition().x)) && xx >= minWidth.floatValue() && (maxWidth == null || xx <= maxWidth.floatValue())) {
            deltaSize.x = delta.x;
        }
        if ((delta.y < 0.0f && (cursorPositionPrev.y <= this.resizeButton.getAbsolutePosition().y + this.resizeButton.getSize().y || cursorPosition.y <= this.resizeButton.getAbsolutePosition().y + this.resizeButton.getSize().y) || delta.y > 0.0f && (cursorPositionPrev.y >= this.resizeButton.getAbsolutePosition().y || cursorPosition.y >= this.resizeButton.getAbsolutePosition().y)) && yy >= minHeight.floatValue() && (maxHeight == null || yy <= maxHeight.floatValue())) {
            deltaSize.y = delta.y;
        }
        Vector2f oldSize = new Vector2f((Vector2fc)this.widget.getSize());
        this.widget.getSize().add((Vector2fc)deltaSize);
        Vector2f newSize = this.widget.getSize();
        if (!oldSize.equals((Vector2fc)newSize, 1.0E-4f)) {
            EventProcessorProvider.getInstance().pushEvent(new ChangeSizeEvent<Widget>(this.widget, event.getContext(), event.getFrame(), (Vector2fc)oldSize, (Vector2fc)newSize));
        }
    }
}

