/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.listener.textarea;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.ScrollablePanel;
import com.spinyowl.legui.component.TextArea;
import com.spinyowl.legui.component.misc.listener.EventUtils;
import com.spinyowl.legui.component.misc.listener.scrollbar.ScrollBarHelper;
import com.spinyowl.legui.event.ScrollEvent;
import com.spinyowl.legui.input.Mouse;
import com.spinyowl.legui.listener.ScrollEventListener;
import com.spinyowl.legui.system.handler.SehUtil;
import java.util.ArrayList;
import org.joml.Vector2f;

public class TextAreaViewportScrollListener
implements ScrollEventListener {
    @Override
    public void process(ScrollEvent event) {
        Vector2f cursorPosition = Mouse.getCursorPosition();
        Object targetComponent = event.getTargetComponent();
        if (EventUtils.hasViewportsInAboveLayersUnderCursor(targetComponent, cursorPosition)) {
            return;
        }
        ArrayList<Component> targetList = new ArrayList<Component>();
        SehUtil.recursiveTargetComponentListSearch(Mouse.getCursorPosition(), event.getTargetComponent(), targetList);
        for (Component component : targetList) {
            if (!(component instanceof TextArea) && !(component instanceof ScrollablePanel)) continue;
            return;
        }
        TextArea textArea = (TextArea)((Component)event.getTargetComponent()).getParent();
        textArea.resizeTextAreaField();
        if (Math.abs(event.getYoffset()) > 0.0) {
            ScrollBarHelper.updateScrollBarValue(event.getYoffset(), event.getContext(), event.getFrame(), textArea.getVerticalScrollBar());
        }
        if (Math.abs(event.getXoffset()) > 0.0) {
            ScrollBarHelper.updateScrollBarValue(event.getXoffset(), event.getContext(), event.getFrame(), textArea.getHorizontalScrollBar());
        }
    }
}

