/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.listener.splitpanel;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.SplitPanel;
import com.spinyowl.legui.component.optional.Orientation;
import com.spinyowl.legui.cursor.Cursor;
import com.spinyowl.legui.cursor.CursorServiceProvider;
import com.spinyowl.legui.event.CursorEnterEvent;
import com.spinyowl.legui.event.Event;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.listener.EventListener;
import java.util.Objects;

public class SplitPanelSeparatorListenerDelegate
implements EventListener<Event> {
    private SplitPanel splitPanel;
    private boolean dragging = false;

    public SplitPanelSeparatorListenerDelegate(SplitPanel splitPanel) {
        this.splitPanel = Objects.requireNonNull(splitPanel);
    }

    @Override
    public void process(Event event) {
        Event e;
        if (!((Component)event.getTargetComponent()).equals(this.splitPanel.getSeparator())) {
            return;
        }
        if (event instanceof MouseClickEvent) {
            e = (MouseClickEvent)event;
            if (((MouseClickEvent)e).getAction() == MouseClickEvent.MouseClickAction.PRESS) {
                this.dragging = true;
            }
            if (((MouseClickEvent)e).getAction() == MouseClickEvent.MouseClickAction.RELEASE) {
                this.dragging = false;
                CursorServiceProvider.getInstance().setCursor(Cursor.ARROW, e.getContext());
            }
        }
        if (event instanceof CursorEnterEvent) {
            e = (CursorEnterEvent)event;
            Orientation orientation = this.splitPanel.getOrientation();
            if (((CursorEnterEvent)e).isEntered() && orientation == Orientation.HORIZONTAL) {
                CursorServiceProvider.getInstance().setCursor(Cursor.H_RESIZE, e.getContext());
            } else if (((CursorEnterEvent)e).isEntered() && orientation != Orientation.HORIZONTAL) {
                CursorServiceProvider.getInstance().setCursor(Cursor.V_RESIZE, e.getContext());
            } else if (!this.dragging) {
                CursorServiceProvider.getInstance().setCursor(Cursor.ARROW, e.getContext());
            }
        }
    }
}

