/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.listener.scrollbar;

import com.spinyowl.legui.component.ScrollBar;
import com.spinyowl.legui.component.event.scrollbar.ScrollBarChangeValueEvent;
import com.spinyowl.legui.component.optional.Orientation;
import com.spinyowl.legui.event.MouseDragEvent;
import com.spinyowl.legui.input.Mouse;
import com.spinyowl.legui.listener.MouseDragEventListener;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import org.joml.Vector2f;

public class ScrollBarMouseDragEventListener
implements MouseDragEventListener {
    @Override
    public void process(MouseDragEvent event) {
        float curPos;
        float dpos;
        float minValue;
        ScrollBar scrollBar = (ScrollBar)event.getTargetComponent();
        if (!scrollBar.isScrolling()) {
            return;
        }
        if (!Mouse.MouseButton.MOUSE_BUTTON_LEFT.isPressed()) {
            return;
        }
        Vector2f pos = scrollBar.getAbsolutePosition();
        Vector2f cursorPosition = Mouse.getCursorPosition();
        float visibleAmount = scrollBar.getVisibleAmount();
        boolean vertical = Orientation.VERTICAL.equals(scrollBar.getOrientation());
        Vector2f guiSize = scrollBar.getSize();
        float arrowSize = scrollBar.isArrowsEnabled() ? scrollBar.getArrowSize() : 0.0f;
        float scrollBarSize = (vertical ? guiSize.y : guiSize.x) - 2.0f * arrowSize;
        float maxValue = scrollBar.getMaxValue();
        float valueRange = maxValue - (minValue = scrollBar.getMinValue());
        if (valueRange - visibleAmount < 0.001f) {
            return;
        }
        float barSize = scrollBarSize * visibleAmount / valueRange;
        if (barSize < 1.0f) {
            barSize = 1.0f;
        }
        if (vertical) {
            dpos = pos.y;
            curPos = cursorPosition.y;
        } else {
            dpos = pos.x;
            curPos = cursorPosition.x;
        }
        float newVal = valueRange * (curPos - (dpos + arrowSize + barSize / 2.0f)) / (scrollBarSize - barSize);
        if (newVal > maxValue) {
            newVal = maxValue;
        } else if (newVal < minValue) {
            newVal = minValue;
        }
        EventProcessorProvider.getInstance().pushEvent(new ScrollBarChangeValueEvent<ScrollBar>(scrollBar, event.getContext(), event.getFrame(), scrollBar.getCurValue(), newVal));
        scrollBar.setCurValue(newVal);
    }
}

