/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.listener.scrollbar;

import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.component.ScrollBar;
import com.spinyowl.legui.component.event.scrollbar.ScrollBarChangeValueEvent;
import com.spinyowl.legui.component.optional.Orientation;
import com.spinyowl.legui.event.Event;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.input.Mouse;
import com.spinyowl.legui.listener.MouseClickEventListener;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.system.context.Context;
import org.joml.Vector2f;

public class ScrollBarMouseClickEventListener
implements MouseClickEventListener {
    @Override
    public void process(MouseClickEvent event) {
        float curPos;
        float left;
        float minValue;
        boolean released;
        ScrollBar scrollBar = (ScrollBar)event.getTargetComponent();
        boolean bl = released = event.getAction() != MouseClickEvent.MouseClickAction.PRESS;
        if (!event.getButton().equals((Object)Mouse.MouseButton.MOUSE_BUTTON_LEFT)) {
            return;
        }
        Vector2f pos = scrollBar.getAbsolutePosition();
        Vector2f cursorPosition = Mouse.getCursorPosition();
        float visibleAmount = scrollBar.getVisibleAmount();
        boolean vertical = Orientation.VERTICAL.equals(scrollBar.getOrientation());
        Vector2f guiSize = scrollBar.getSize();
        float arrowSize = scrollBar.isArrowsEnabled() ? scrollBar.getArrowSize() : 0.0f;
        float scrollBarSize = (vertical ? guiSize.y : guiSize.x) - 2.0f * arrowSize;
        float maxValue = scrollBar.getMaxValue();
        float valueRange = maxValue - (minValue = scrollBar.getMinValue());
        if (valueRange - visibleAmount < 0.001f) {
            return;
        }
        float barSize = scrollBarSize * visibleAmount / valueRange;
        if (barSize < 1.0f) {
            barSize = 1.0f;
        }
        float curValue = scrollBar.getCurValue();
        float scrollPosAccordingToScrollBounds = (scrollBarSize - barSize) * curValue / valueRange;
        if (vertical) {
            left = pos.y + scrollPosAccordingToScrollBounds + arrowSize;
            curPos = cursorPosition.y;
        } else {
            left = pos.x + scrollPosAccordingToScrollBounds + arrowSize;
            curPos = cursorPosition.x;
        }
        if (curPos < left) {
            float newVal = curValue - 0.5f * visibleAmount * valueRange / (valueRange - visibleAmount);
            if (!released) {
                this.updateViewport(event, scrollBar, maxValue, minValue, newVal);
            }
            scrollBar.setScrolling(false);
        } else if (curPos > left + barSize) {
            float newVal = curValue + 0.5f * visibleAmount * valueRange / (valueRange - visibleAmount);
            if (!released) {
                this.updateViewport(event, scrollBar, maxValue, minValue, newVal);
            }
            scrollBar.setScrolling(false);
        } else {
            scrollBar.setScrolling(!released);
        }
    }

    private void updateViewport(Event event, ScrollBar scrollBar, float maxValue, float minValue, float newValue) {
        float valueToUse = newValue;
        if (newValue > maxValue) {
            valueToUse = maxValue;
        } else if (newValue < minValue) {
            valueToUse = minValue;
        }
        Context context = event.getContext();
        Frame frame = event.getFrame();
        float curValue = scrollBar.getCurValue();
        EventProcessorProvider.getInstance().pushEvent(new ScrollBarChangeValueEvent<ScrollBar>(scrollBar, context, frame, curValue, valueToUse));
        scrollBar.setCurValue(valueToUse);
    }
}

