/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.listener.component;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.event.KeyEvent;
import com.spinyowl.legui.listener.EventListener;
import com.spinyowl.legui.system.context.Context;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TabKeyEventListener
implements EventListener<KeyEvent> {
    private Comparator<? super Component> comparator = Comparator.comparingInt(Component::getTabIndex);

    @Override
    public void process(KeyEvent event) {
        if (event.getTargetComponent() == null) {
            return;
        }
        if (event.getKey() == 258 && event.getAction() != 1) {
            boolean shiftPressed;
            boolean controlPressed = (event.getMods() & 2) != 0;
            boolean bl = shiftPressed = (event.getMods() & 1) != 0;
            if (controlPressed && !shiftPressed) {
                Component next = this.findNext((Component)event.getTargetComponent());
                Context.setFocusedGui(next, event.getContext(), event.getFrame());
            } else if (controlPressed) {
                Component prev = this.findPrev((Component)event.getTargetComponent());
                Context.setFocusedGui(prev, event.getContext(), event.getFrame());
            }
        }
    }

    private Component findPrev(Component component) {
        if (!component.isVisible()) {
            return null;
        }
        Component prev = null;
        if (this.isFF(component)) {
            prev = component;
        }
        prev = this.findPrevInParent(component, component.getParent(), prev);
        return prev;
    }

    private Component findPrevInParent(Component component, Component parent, Component prev) {
        if (parent == null) {
            return prev;
        }
        List<Component> childComponents = parent.getChildComponents();
        childComponents.sort(this.comparator);
        Collections.reverse(childComponents);
        int index = childComponents.indexOf(component);
        if (index != childComponents.size() - 1) {
            for (int i = index + 1; i < childComponents.size(); ++i) {
                Component child = childComponents.get(i);
                if (!child.isVisible()) continue;
                if (!child.isEmpty()) {
                    Component cprev = this.findPrevInChildComponents(child.getChildComponents(), prev);
                    if (prev == cprev) continue;
                    return cprev;
                }
                if (!this.isFF(child)) continue;
                return child;
            }
            prev = this.findPrevInParent(parent, parent.getParent(), prev);
        } else {
            if (this.isFF(parent)) {
                return parent;
            }
            prev = this.findPrevInParent(parent, parent.getParent(), prev);
        }
        return prev;
    }

    private boolean isFF(Component component) {
        return component.isTabFocusable() && component.isFocusable();
    }

    private Component findPrevInChildComponents(List<Component> childComponents, Component previous) {
        Component previousComponent = previous;
        childComponents.sort(this.comparator);
        Collections.reverse(childComponents);
        for (Component child : childComponents) {
            if (!child.isVisible()) continue;
            if (!child.isEmpty()) {
                Component cprev = this.findPrevInChildComponents(child.getChildComponents(), previousComponent);
                if (previousComponent == cprev) continue;
                return cprev;
            }
            if (!this.isFF(child)) continue;
            return child;
        }
        return previousComponent;
    }

    private Component findNext(Component component) {
        if (!component.isVisible()) {
            return null;
        }
        Component next = null;
        if (this.isFF(component)) {
            next = component;
        }
        if (component.isEmpty()) {
            next = this.findNextInParent(component, component.getParent(), next);
        } else {
            next = this.findNextInChildComponents(component.getChildComponents(), next);
            if (next == component) {
                next = this.findNextInParent(component, component.getParent(), next);
            }
        }
        return next;
    }

    private Component findNextInChildComponents(List<Component> childComponents, Component next) {
        if (childComponents.isEmpty()) {
            return next;
        }
        childComponents.sort(this.comparator);
        for (Component child : childComponents) {
            Component cnext;
            if (!child.isVisible()) continue;
            if (this.isFF(child)) {
                return child;
            }
            if (child.isEmpty() || next == (cnext = this.findNextInChildComponents(child.getChildComponents(), next))) continue;
            return cnext;
        }
        return next;
    }

    private Component findNextInParent(Component component, Component parent, Component next) {
        if (parent == null) {
            return next;
        }
        List<Component> childComponents = parent.getChildComponents();
        childComponents.sort(this.comparator);
        int index = childComponents.indexOf(component);
        if (index != childComponents.size() - 1) {
            for (int i = index + 1; i < childComponents.size(); ++i) {
                Component cnext;
                Component child = childComponents.get(i);
                if (!child.isVisible()) continue;
                if (this.isFF(child)) {
                    return child;
                }
                if (child.isEmpty() || next == (cnext = this.findNextInChildComponents(child.getChildComponents(), next))) continue;
                return cnext;
            }
            next = this.findNextInParent(parent, parent.getParent(), next);
        } else {
            next = this.findNextInParent(parent, parent.getParent(), next);
        }
        return next;
    }
}

