/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.animation.scrollbar;

import com.spinyowl.legui.animation.Animation;
import com.spinyowl.legui.component.ScrollBar;
import com.spinyowl.legui.component.Viewport;
import com.spinyowl.legui.component.optional.Orientation;
import java.lang.ref.WeakReference;
import org.joml.Vector2f;

public class ScrollBarAnimation
extends Animation {
    private WeakReference<ScrollBar> scrollBar;

    public ScrollBarAnimation(ScrollBar scrollBar) {
        this.scrollBar = new WeakReference<ScrollBar>(scrollBar);
    }

    @Override
    protected boolean animate(double delta) {
        ScrollBar scrollBar = (ScrollBar)this.scrollBar.get();
        if (scrollBar == null) {
            return true;
        }
        Viewport viewport = scrollBar.getViewport();
        if (scrollBar.isVisible() && viewport != null) {
            Vector2f viewportSize = viewport.getViewportSize();
            Vector2f viewportViewSize = viewport.getViewportViewSize();
            if (viewportSize == null || viewportViewSize == null) {
                return true;
            }
            float range = scrollBar.getMaxValue() - scrollBar.getMinValue();
            float allSize = Orientation.HORIZONTAL.equals(scrollBar.getOrientation()) ? viewportViewSize.x : viewportViewSize.y;
            float viewSize = Orientation.HORIZONTAL.equals(scrollBar.getOrientation()) ? viewportSize.x : viewportSize.y;
            scrollBar.setVisibleAmount(allSize >= viewSize ? range * viewSize / allSize : range);
        }
        return false;
    }
}

