/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.animation;

import com.spinyowl.legui.animation.Animation;
import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.ScrollBar;
import java.lang.ref.WeakReference;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public abstract class ViewportAnimation<T extends Component>
extends Animation {
    private static final double DOUBLE_THRESHOLD = 0.001;
    private double updateTime;
    private double deltaSum;
    private double deltaT;
    private Vector2f initialPosition = new Vector2f();
    private WeakReference<T> componentReference;

    public ViewportAnimation(T component, double updateTime) {
        this.componentReference = new WeakReference<T>(component);
        this.updateTime = updateTime;
    }

    public WeakReference<T> getComponentReference() {
        return this.componentReference;
    }

    @Override
    protected boolean animate(double delta) {
        Component component = (Component)this.getComponentReference().get();
        if (component != null) {
            this.deltaSum += delta;
            if (this.deltaSum >= 0.001) {
                this.updateViewport(component, this.deltaSum);
                this.deltaSum = 0.0;
            }
            return false;
        }
        return true;
    }

    protected abstract void updateViewport(T var1, double var2);

    protected void updateViewport(Component viewport, Component container, ScrollBar verticalScrollBar, ScrollBar horizontalScrollBar, double delta) {
        float vh = viewport.getSize().y;
        float ch = container.getSize().y;
        float targetY = this.calculateTargetPosition(verticalScrollBar, vh, ch);
        float vw = viewport.getSize().x;
        float cw = container.getSize().x;
        float targetX = this.calculateTargetPosition(horizontalScrollBar, vw, cw);
        if ((double)Math.abs(targetX - this.initialPosition.x) < 0.001 && (double)Math.abs(targetY - this.initialPosition.y) < 0.001) {
            this.deltaT = 0.0;
            this.initialPosition.set((Vector2fc)container.getPosition());
            return;
        }
        Vector2f targetPosition = new Vector2f(targetX, targetY);
        if (this.deltaT < this.updateTime) {
            if (this.deltaT == 0.0) {
                this.initialPosition.set((Vector2fc)container.getPosition());
            }
            this.deltaT += delta;
            double tt = this.deltaT / this.updateTime;
            double modifier = this.easeInQuad(tt);
            Vector2f position = new Vector2f((Vector2fc)targetPosition).sub((Vector2fc)this.initialPosition).mul((float)modifier).add((Vector2fc)this.initialPosition);
            container.setPosition(position);
        } else {
            Vector2f position = new Vector2f(targetX, targetY);
            this.initialPosition.set((Vector2fc)position);
            container.setPosition(position);
        }
    }

    private float calculateTargetPosition(ScrollBar horizontalScrollBar, float vw, float cw) {
        float targetX;
        if (vw > cw) {
            targetX = 0.0f;
        } else {
            float curValue = horizontalScrollBar.getCurValue();
            float maxValue = horizontalScrollBar.getMaxValue();
            float minValue = horizontalScrollBar.getMinValue();
            targetX = (vw - cw) * curValue / (maxValue - minValue);
        }
        return targetX;
    }

    private double easeInQuad(double t) {
        return t * t;
    }
}

