/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.Button;
import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Label;
import com.spinyowl.legui.component.Panel;
import com.spinyowl.legui.component.event.widget.WidgetCloseEvent;
import com.spinyowl.legui.component.misc.listener.widget.WidgetCloseButMouseClickEventListener;
import com.spinyowl.legui.component.misc.listener.widget.WidgetDragListener;
import com.spinyowl.legui.component.misc.listener.widget.WidgetMinimizeButMouseClickEventListener;
import com.spinyowl.legui.component.misc.listener.widget.WidgetResizeButtonDragListener;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.event.MouseDragEvent;
import com.spinyowl.legui.icon.CharIcon;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.listener.EventListener;
import com.spinyowl.legui.listener.MouseDragEventListener;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.style.flex.FlexStyle;
import com.spinyowl.legui.style.length.Length;
import com.spinyowl.legui.theme.Themes;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;

public class Widget
extends Component {
    public static final String DEFAULT_WIDGET_TITLE = "Widget";
    private static final int INITIAL_TITLE_HEIGHT = 20;
    private static final int CLOSE_ICON_CHAR = 62893;
    private static final int MINIMIZE_ICON_CHAR = 62896;
    private static final int MAXIMIZE_ICON_CHAR = 62895;
    private MouseDragEventListener mouseDragEventLeguiEventListener;
    private Icon closeIcon;
    private Icon minimizeIcon;
    private Icon maximizeIcon;
    private boolean draggable = true;
    private boolean minimized = false;
    private boolean resizable = true;
    private Vector2f maximizedSize = new Vector2f();
    private Component container;
    private Component titleContainer;
    private Label title;
    private Button closeButton;
    private Button minimizeButton;
    private Button resizeButton;
    private Length maximizedMinWidth;
    private Length maximizedMinHeight;
    private Length maximizedMaxWidth;
    private Length maximizedMaxHeight;
    private Length maximizedWidth;
    private Length maximizedHeight;
    private boolean ascendible = true;

    public Widget() {
        this.initialize(DEFAULT_WIDGET_TITLE);
    }

    public Widget(boolean ascendible) {
        this.ascendible = ascendible;
        this.initialize(DEFAULT_WIDGET_TITLE);
    }

    public Widget(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize(DEFAULT_WIDGET_TITLE);
    }

    public Widget(float x, float y, float width, float height, boolean ascendible) {
        super(x, y, width, height);
        this.ascendible = ascendible;
        this.initialize(DEFAULT_WIDGET_TITLE);
    }

    public Widget(Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize(DEFAULT_WIDGET_TITLE);
    }

    public Widget(Vector2f position, Vector2f size, boolean ascendible) {
        super(position, size);
        this.ascendible = ascendible;
        this.initialize(DEFAULT_WIDGET_TITLE);
    }

    public Widget(String title) {
        this.initialize(title);
    }

    public Widget(String title, boolean ascendible) {
        this.ascendible = ascendible;
        this.initialize(title);
    }

    public Widget(String title, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize(title);
    }

    public Widget(String title, float x, float y, float width, float height, boolean ascendible) {
        super(x, y, width, height);
        this.ascendible = ascendible;
        this.initialize(title);
    }

    public Widget(String title, Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize(title);
    }

    public Widget(String title, Vector2f position, Vector2f size, boolean ascendible) {
        super(position, size);
        this.ascendible = ascendible;
        this.initialize(title);
    }

    public void initialize(String title) {
        this.getStyle().setDisplay(Style.DisplayType.FLEX);
        this.getStyle().getFlexStyle().setFlexDirection(FlexStyle.FlexDirection.COLUMN);
        this.getStyle().setMinWidth(50.0f);
        this.getStyle().setMinHeight(50.0f);
        this.getStyle().setPadding(0.0f);
        this.titleContainer = new Panel();
        this.titleContainer.setTabFocusable(false);
        this.titleContainer.getStyle().setDisplay(Style.DisplayType.FLEX);
        this.titleContainer.getStyle().setPosition(Style.PositionType.RELATIVE);
        this.titleContainer.getSize().y = 20.0f;
        this.titleContainer.getStyle().setHeight(20.0f);
        this.titleContainer.getStyle().setMinHeight(20.0f);
        this.titleContainer.getStyle().setMaxHeight(20.0f);
        this.titleContainer.getStyle().getFlexStyle().setFlexGrow(1);
        this.titleContainer.getStyle().getFlexStyle().setFlexShrink(1);
        this.titleContainer.getStyle().getFlexStyle().setFlexDirection(FlexStyle.FlexDirection.ROW);
        this.title = new Label(title);
        this.title.getStyle().setPosition(Style.PositionType.RELATIVE);
        this.title.getStyle().setMaxWidth(Float.MAX_VALUE);
        this.title.getSize().y = 20.0f;
        this.title.getStyle().setMaxHeight(20.0f);
        this.title.getStyle().setHeight(20.0f);
        this.title.getStyle().setMinWidth(0.0f);
        this.title.getStyle().setMinHeight(20.0f);
        this.title.getStyle().setBorder(null);
        this.title.getStyle().getFlexStyle().setFlexGrow(1);
        this.title.getStyle().getFlexStyle().setFlexShrink(1);
        this.title.setTabFocusable(false);
        this.mouseDragEventLeguiEventListener = new WidgetDragListener(this);
        this.title.getListenerMap().addListener(MouseDragEvent.class, this.mouseDragEventLeguiEventListener);
        this.closeButton = new Button("");
        int iconSize = 13;
        this.closeIcon = new CharIcon(new Vector2f((float)iconSize), "materialdesignicons", '\uf5ad', ColorConstants.black());
        this.closeIcon.setHorizontalAlign(HorizontalAlign.CENTER);
        this.closeIcon.setVerticalAlign(VerticalAlign.MIDDLE);
        this.closeButton.getStyle().setPosition(Style.PositionType.RELATIVE);
        this.closeButton.getStyle().getBackground().setIcon(this.closeIcon);
        this.closeButton.getStyle().getBackground().setColor(ColorConstants.transparent());
        this.closeButton.getSize().y = 20.0f;
        this.closeButton.getStyle().setMaxWidth(20.0f);
        this.closeButton.getStyle().setMaxHeight(20.0f);
        this.closeButton.getStyle().setMinWidth(20.0f);
        this.closeButton.getStyle().setMinHeight(20.0f);
        this.closeButton.getStyle().setWidth(20.0f);
        this.closeButton.getStyle().setHeight(20.0f);
        this.closeButton.getStyle().setBorder(null);
        this.closeButton.getStyle().getFlexStyle().setFlexGrow(1);
        this.closeButton.getStyle().getFlexStyle().setFlexShrink(1);
        this.closeButton.getListenerMap().addListener(MouseClickEvent.class, new WidgetCloseButMouseClickEventListener(this));
        this.closeButton.getStyle().setVerticalAlign(VerticalAlign.MIDDLE);
        this.closeButton.getStyle().setHorizontalAlign(HorizontalAlign.CENTER);
        this.closeButton.setTabFocusable(false);
        this.minimizeButton = new Button("");
        this.minimizeButton.setTabFocusable(false);
        this.minimizeIcon = new CharIcon(new Vector2f((float)iconSize), "materialdesignicons", '\uf5b0', ColorConstants.black());
        this.minimizeIcon.setHorizontalAlign(HorizontalAlign.CENTER);
        this.minimizeIcon.setVerticalAlign(VerticalAlign.MIDDLE);
        this.maximizeIcon = new CharIcon(new Vector2f((float)iconSize), "materialdesignicons", '\uf5af', ColorConstants.black());
        this.maximizeIcon.setHorizontalAlign(HorizontalAlign.CENTER);
        this.maximizeIcon.setVerticalAlign(VerticalAlign.MIDDLE);
        this.minimizeButton.getStyle().getBackground().setColor(ColorConstants.transparent());
        this.minimizeButton.getStyle().getBackground().setIcon(this.minimizeIcon);
        this.minimizeButton.getStyle().setPosition(Style.PositionType.RELATIVE);
        this.minimizeButton.getSize().y = 20.0f;
        this.minimizeButton.getStyle().setMaxWidth(20.0f);
        this.minimizeButton.getStyle().setMaxHeight(20.0f);
        this.minimizeButton.getStyle().setMinWidth(20.0f);
        this.minimizeButton.getStyle().setMinHeight(20.0f);
        this.minimizeButton.getStyle().setWidth(20.0f);
        this.minimizeButton.getStyle().setHeight(20.0f);
        this.minimizeButton.getStyle().getFlexStyle().setFlexGrow(1);
        this.minimizeButton.getStyle().getFlexStyle().setFlexShrink(1);
        this.minimizeButton.getStyle().setBorder(null);
        this.minimizeButton.getListenerMap().addListener(MouseClickEvent.class, new WidgetMinimizeButMouseClickEventListener(this));
        this.minimizeButton.getStyle().setVerticalAlign(VerticalAlign.MIDDLE);
        this.minimizeButton.getStyle().setHorizontalAlign(HorizontalAlign.CENTER);
        this.container = new Panel();
        this.applyStylesToContainer(this.container);
        this.titleContainer.add(this.title);
        this.titleContainer.add(this.minimizeButton);
        this.titleContainer.add(this.closeButton);
        this.resizeButton = new Button("");
        CharIcon icon = new CharIcon("materialdesignicons", '\uf45d');
        icon.setSize(new Vector2f(20.0f, 20.0f));
        icon.setPosition(new Vector2f(-10.0f, -10.0f));
        this.resizeButton.getStyle().getBackground().setIcon(icon);
        this.resizeButton.getStyle().setWidth(10.0f);
        this.resizeButton.getStyle().setHeight(10.0f);
        this.resizeButton.getStyle().setBottom(0.0f);
        this.resizeButton.getStyle().setRight(0.0f);
        this.resizeButton.getStyle().setBorder(null);
        this.resizeButton.getStyle().getBackground().setColor(ColorConstants.transparent());
        this.resizeButton.setTabFocusable(false);
        this.resizeButton.getListenerMap().addListener(MouseDragEvent.class, new WidgetResizeButtonDragListener(this.resizeButton, this));
        this.add(this.titleContainer);
        this.add(this.container);
        this.add(this.resizeButton);
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(Widget.class).applyAll(this);
    }

    public void applyStylesToContainer(Component container) {
        container.setTabFocusable(false);
        container.getStyle().getFlexStyle().setFlexShrink(1);
        container.getStyle().getFlexStyle().setFlexGrow(1);
        container.getStyle().setPosition(Style.PositionType.RELATIVE);
    }

    public float getTitleHeight() {
        return this.titleContainer.getSize().y;
    }

    public void setTitleHeight(float titleHeight) {
        this.titleContainer.getSize().y = titleHeight;
        this.titleContainer.getStyle().setMinHeight(titleHeight);
        this.titleContainer.getStyle().setHeight(titleHeight);
        this.titleContainer.getStyle().setMaxHeight(titleHeight);
        this.title.getStyle().setMinHeight(titleHeight);
        this.title.getStyle().setHeight(titleHeight);
        this.title.getStyle().setMaxHeight(titleHeight);
    }

    public boolean isTitleEnabled() {
        return this.titleContainer.isVisible();
    }

    public void setTitleEnabled(boolean titleEnabled) {
        if (this.minimized) {
            return;
        }
        this.titleContainer.getStyle().setDisplay(titleEnabled ? Style.DisplayType.FLEX : Style.DisplayType.NONE);
    }

    public boolean isCloseable() {
        return this.closeButton.isVisible();
    }

    public void setCloseable(boolean closeable) {
        this.closeButton.getStyle().setDisplay(closeable ? Style.DisplayType.MANUAL : Style.DisplayType.NONE);
    }

    public Button getCloseButton() {
        return this.closeButton;
    }

    public Button getMinimizeButton() {
        return this.minimizeButton;
    }

    public Component getTitleContainer() {
        return this.titleContainer;
    }

    public TextState getTitleTextState() {
        return this.title.getTextState();
    }

    public Label getTitle() {
        return this.title;
    }

    public Vector4f getCloseButtonColor() {
        return this.closeButton.getStyle().getTextColor();
    }

    public void setCloseButtonColor(Vector4f closeButtonColor) {
        this.closeButton.getStyle().setTextColor(closeButtonColor);
    }

    public Component getContainer() {
        return this.container;
    }

    public void setContainer(Component container) {
        this.remove(this.container);
        this.container = container;
        this.add(1, this.container);
        this.applyStylesToContainer(this.container);
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        if (this.draggable != draggable) {
            if (draggable) {
                this.title.getListenerMap().addListener(MouseDragEvent.class, this.mouseDragEventLeguiEventListener);
            } else {
                this.title.getListenerMap().removeListener(MouseDragEvent.class, this.mouseDragEventLeguiEventListener);
            }
            this.draggable = draggable;
        }
    }

    public boolean isMinimizable() {
        return this.minimizeButton.isVisible();
    }

    public void setMinimizable(boolean minimizable) {
        this.minimizeButton.getStyle().setDisplay(minimizable ? Style.DisplayType.MANUAL : Style.DisplayType.NONE);
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean minimized) {
        if (this.minimized != minimized) {
            this.minimized = minimized;
            if (minimized) {
                this.minimize();
            } else {
                this.maximize();
            }
            this.updateIcons();
        }
    }

    public void hide() {
        this.getStyle().setDisplay(Style.DisplayType.NONE);
    }

    public void show() {
        this.getStyle().setDisplay(Style.DisplayType.FLEX);
    }

    private void minimize() {
        if (this.isTitleEnabled()) {
            Vector2f size = this.getSize();
            this.maximizedSize.set((Vector2fc)size);
            this.maximizedMinWidth = this.getStyle().getMinWidth();
            this.maximizedMinHeight = this.getStyle().getMinHeight();
            this.maximizedMaxWidth = this.getStyle().getMaxWidth();
            this.maximizedMaxHeight = this.getStyle().getMaxHeight();
            this.maximizedWidth = this.getStyle().getWidth();
            this.maximizedHeight = this.getStyle().getHeight();
            float titleHeight = this.getTitleHeight();
            size.set(size.x, titleHeight);
            this.getStyle().setMaxHeight(titleHeight);
            this.getStyle().setHeight(titleHeight);
            this.getStyle().setMinHeight(titleHeight);
            if (this.resizable) {
                this.resizeButton.getStyle().setDisplay(Style.DisplayType.NONE);
            }
        }
    }

    private void maximize() {
        if (this.isTitleEnabled()) {
            this.getSize().set((Vector2fc)this.maximizedSize);
            this.getStyle().setMaxWidth(this.maximizedMaxWidth);
            this.getStyle().setMaxHeight(this.maximizedMaxHeight);
            this.getStyle().setMinWidth(this.maximizedMinWidth);
            this.getStyle().setMinHeight(this.maximizedMinHeight);
            this.getStyle().setWidth(this.maximizedWidth);
            this.getStyle().setHeight(this.maximizedHeight);
            if (this.resizable) {
                this.resizeButton.getStyle().setDisplay(Style.DisplayType.MANUAL);
            }
        }
    }

    public Icon getCloseIcon() {
        return this.closeIcon;
    }

    public void setCloseIcon(Icon closeIcon) {
        this.closeIcon = closeIcon;
        this.updateIcons();
    }

    public Icon getMaximizeIcon() {
        return this.maximizeIcon;
    }

    public void setMaximizeIcon(Icon maximizeIcon) {
        this.maximizeIcon = maximizeIcon;
        this.updateIcons();
    }

    public Icon getMinimizeIcon() {
        return this.minimizeIcon;
    }

    public void setMinimizeIcon(Icon minimizeIcon) {
        this.minimizeIcon = minimizeIcon;
        this.updateIcons();
    }

    private void updateIcons() {
        this.closeButton.getStyle().getBackground().setIcon(this.closeIcon);
        this.minimizeButton.getStyle().getBackground().setIcon(this.minimized ? this.maximizeIcon : this.minimizeIcon);
    }

    public void addWidgetCloseEventListener(EventListener<WidgetCloseEvent> eventListener) {
        this.getListenerMap().addListener(WidgetCloseEvent.class, eventListener);
    }

    public List<EventListener<WidgetCloseEvent>> getWidgetCloseEvents() {
        return this.getListenerMap().getListeners(WidgetCloseEvent.class);
    }

    public void removeWidgetCloseEventListener(EventListener<WidgetCloseEvent> eventListener) {
        this.getListenerMap().removeListener(WidgetCloseEvent.class, eventListener);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Widget widget = (Widget)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.draggable, widget.draggable).append(this.minimized, widget.minimized).append((Object)this.maximizedSize, (Object)widget.maximizedSize).append((Object)this.container, (Object)widget.container).append((Object)this.title, (Object)widget.title).append((Object)this.closeButton, (Object)widget.closeButton).append((Object)this.minimizeButton, (Object)widget.minimizeButton).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.draggable).append(this.minimized).append((Object)this.maximizedSize).append((Object)this.container).append((Object)this.title).append((Object)this.closeButton).append((Object)this.minimizeButton).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("draggable", this.draggable).append("minimized", this.minimized).append("maximizedSize", (Object)this.maximizedSize).append("container", (Object)this.container).append("title", (Object)this.title).append("closeButton", (Object)this.closeButton).append("minimizeButton", (Object)this.minimizeButton).toString();
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        this.resizeButton.getStyle().setDisplay(resizable ? Style.DisplayType.MANUAL : Style.DisplayType.NONE);
    }

    public Button getResizeButton() {
        return this.resizeButton;
    }

    public boolean isAscendible() {
        return this.ascendible;
    }

    public void setAscendible(boolean ascendible) {
        this.ascendible = ascendible;
    }
}

